package com.xforceplus.elephant.image.servicehandler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.baseconst.ConfigConstants;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.domain.config.ConfigDictionaryService;
import com.xforceplus.elephant.image.core.domain.config.bean.ConfigDictionaryItem;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketDetailFacade;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketFacade;
import com.xforceplus.elephant.image.core.util.CommonEntityServiceHandler;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CheckStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.TicketPlaneDetail;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleCreateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleDeleteCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleQueryCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleUpdateCmd;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * 飞机票明细二开
 * @author rongying
 * @date 2022/3/30 17:37
 */
@RequiredArgsConstructor
@Service
public class NewTicketPlaneDetailService extends CommonEntityServiceHandler {

    private final TicketFacade ticketFacade;
    private final TicketDetailFacade ticketDetailFacade;
    private final ConfigDictionaryService configDictionaryService;

    @Override
    public Either<String, Map<String, Object>> singleQuery(SingleQueryCmd cmd) {
        return null;
    }

    @QueryHandler(condition = "msg.getMetaData().get('code').equals('ticketPlaneDetail')")
    @Override
    public Either<String, Integer> singleDelete(SingleDeleteCmd cmd) {
        final Either<String, Integer> singleDelete = super.singleDelete(cmd);
        if (singleDelete.isRight()) {
            final Long ticketId = getTicketId(Long.valueOf(cmd.getId()));
            if (null != ticketId) {
                checkVerifyStatus(ticketId);
            }
        }
        return singleDelete;
    }

    @QueryHandler(condition = "msg.getMetaData().get('code').equals('ticketPlaneDetail')")
    @Override
    public Either<String, Long> singleCreate(SingleCreateCmd cmd) {
        if (null == cmd.getBody() || cmd.getBody().get("items.id") == null) {
            return Either.left("保存失败，父单证ID不能为空");
        }
        final Long ticketId = Long.valueOf(cmd.getBody().get("items.id").toString());
        cmd.getBody().put(TicketPlaneDetail.TICKET_ID.code(), ticketId);
        final Either<String, Long> singleCreate = super.singleCreate(cmd);
        if (singleCreate.isRight()) {
            checkVerifyStatus(ticketId);
        }
        return singleCreate;
    }

    @QueryHandler(condition = "msg.getMetaData().get('code').equals('ticketPlaneDetail')")
    @Override
    public Either<String, Integer> singleUpdate(SingleUpdateCmd cmd) {
        final Either<String, Integer> singleUpdate = super.singleUpdate(cmd);
        if (singleUpdate.isRight()) {
            final Long ticketId = getTicketId(cmd.getId());
            if (null != ticketId) {
                checkVerifyStatus(ticketId);
            }
        }
        return singleUpdate;
    }

    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        return null;
    }

    /**
     * 查询单证ID
     * @author rongying
     * @date 2022/3/31 9:39
     * @param detailId 明细ID
     * @return java.lang.Long
     */
    private Long getTicketId(Long detailId) {
        final Map<String, Object> detailMap = ticketDetailFacade.selectOne(detailId, EntityMeta.TicketPlane.code());
        if (ValidatorUtil.isEmpty(detailMap)) {
            return null;
        }
        return Long.valueOf(detailMap.get(TicketPlaneDetail.TICKET_ID.code()).toString());
    }

    /**
     * 检查验真状态
     * @param ticketId 单证ID
     */
    private void checkVerifyStatus(Long ticketId) {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆.");
        }
        final List<Ticket> ticketList = ticketFacade.selectTicketListByIds(authorizedUser.getTenantId(), Arrays.asList(ticketId));
        if (ValidatorUtil.isEmpty(ticketList)) {
            return;
        }
        final Ticket ticket = ticketList.get(0);
        //查询字典
        final List<ConfigDictionaryItem> dictionaryItemList = configDictionaryService.selectItems(authorizedUser.getTenantId(), ConfigConstants.CONFIG_DICT_CODE_TICKET_CHEKCT_CONTENT);
        final Map<String, ConfigDictionaryItem> dictionaryMap =
            !CollectionUtils.isEmpty(dictionaryItemList) ? dictionaryItemList.stream().collect(Collectors.toMap(ConfigDictionaryItem::getItemCode, a -> a, (k1, k2) -> k1)) : Maps.newHashMap();
        final ConfigDictionaryItem dictionaryItem = dictionaryMap.get(ticket.getInvoiceType());
        if (null == dictionaryItem) {
            return;
        }
        //获取验真表达式（小开关）是否需要验真
        if (ValidatorUtil.isEmpty(dictionaryItem.getVerifyExpression())) {
            return;
        }
        final ExpressionParser parser = new SpelExpressionParser();
        final EvaluationContext context = new StandardEvaluationContext();
        context.setVariable("obj", ticket.toOQSMap());
        context.setVariable("details", ticketDetailFacade.selectTicketDetail(ticketId, ticket.getTicketCode())
            .stream().map(item -> new JSONObject(item)).collect(Collectors.toList()));
        final boolean verifyExpression = parser.parseExpression(dictionaryItem.getVerifyExpression()).getValue(context, Boolean.class);
        //更新发票无需验真
        if (!verifyExpression) {
            updateCheckStatus(ticket, CheckStatus._4.getCode(), "当前单证类型不支持验真.");
            return;
        }
        //校验是否变成待验真
        final JSONArray jsonArray = JSONArray.parseArray(dictionaryItem.getVerifyFields());
        if (null == jsonArray || jsonArray.size() < 0) {
            updateCheckStatus(ticket, CheckStatus._4.getCode(), "当前单证类型不支持验真.");
            return;
        }
        //类型变更：校验是否开启验真
        if (!dictionaryItem.isCheckVerify()) {
            updateCheckStatus(ticket, CheckStatus._4.getCode(), "当前单证类型不支持验真.");
            return;
        }
        //置验真状态，由客户发起重新验真
        updateCheckStatus(ticket, CheckStatus._0.getCode(), "");
    }

    /**
     * 重置验真状态
     *
     * @param ticket 单证
     * @param checkStatus 需要更新 - 验真状态
     * @param remark 备注
     */
    private void updateCheckStatus(Ticket ticket, String checkStatus, String remark) {
        //修改的验真状态与现有状态一致，不变更
        if (checkStatus.toString().equals(ticket.getCheckStatus())) {
            return;
        }
        final Map<String, Object> entityMap = new HashMap<>();
        entityMap.put(EntityMeta.Ticket.CHECK_STATUS.code(), checkStatus);
        entityMap.put(EntityMeta.Ticket.CHECK_REMARK.code(), remark);
        entityMap.put(EntityMeta.Ticket.CHECK_TASK_ID.code(), "");
        entityMap.put(EntityMeta.Ticket.CHECK_USER_ID.code(), 0L);
        entityMap.put(EntityMeta.Ticket.CHECK_USER_NAME.code(), "");
        ticketFacade.updateTicketByParam(ticket.getId(), ticket.getTicketCode(), entityMap);
    }

}
