package com.xforceplus.elephant.image.servicehandler;

import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.image.core.facade.application.collect.task.TaskFacade;
import com.xforceplus.elephant.image.core.repository.model.TaskQueueEntity;
import com.xforceplus.elephant.image.core.util.CommonEntityServiceHandler;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @author liuhongbin
 * @description 任务查询二开
 * @date 2021/3/15 16:19
 */
@RequiredArgsConstructor
@Service
public class TaskQueueHandler extends CommonEntityServiceHandler {

    private final TaskFacade taskFacade;

    @QueryHandler(condition = "msg.getMetaData().get('code').equals('taskQueue')")
    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        final DataCollection<TaskQueueEntity> taskResult = taskFacade.findByCondition(cmd.getConditionQueryRequest());
        final List<Map<String, Object>> taskQueues = taskResult.getRows().stream()
            .map(entity -> BeanUtils.convertJSON(entity))
            .collect(Collectors.toList());
        return Either.right(new Tuple2<>(taskResult.getRowNum(), taskQueues));
    }

}
