package com.xforceplus.elephant.image.servicehandler;

import com.google.api.client.util.Maps;
import com.xforceplus.elephant.basecommon.baseconst.ReleationConstants;
import com.xforceplus.elephant.image.core.domain.common.TicketSupport;
import com.xforceplus.elephant.image.core.util.CommonEntityServiceHandler;
import com.xforceplus.general.utils.GeneralUtil;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.SystemLabel;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.var;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Slf4j
@RequiredArgsConstructor
@Service
public class TicketInvoiceDetailHandler extends CommonEntityServiceHandler {

    private static final String LABEL_NAME = "system_label_name";
    private final TicketSupport ticketSupport;

    @QueryHandler(condition = "msg.getMetaData().get('code').equals('ticketInvoiceDetail') || msg.getMetaData().get('parentCode').equals('ticketPlaneDetail')"
        + " || msg.getMetaData().get('parentCode').equals('ticketMachineDetail') || msg.getMetaData().get('parentCode').equals('ticketCustomsPaymentDetail')"
        + " || msg.getMetaData().get('code').equals('ticketCustomsPaymentDetail')")
    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        final var result = super.conditionSearch(cmd);
        if (result.isLeft()) {
            return Either.left(String.valueOf(result.getLeft()));
        }
        final var dataList = result.get()._2();
        if (containsKey(cmd.getConditionQueryRequest(), ReleationConstants.SYSTEM_LABEL_ID) && CollectionUtils.isNotEmpty(dataList)) {
            final var labels = ticketSupport.getSystemLabels(dataList);
            final Map<String, String> labelMap = CollectionUtils.isEmpty(labels) ? Maps.newHashMap() :
                labels.stream().collect(Collectors.toMap(k -> GeneralUtil.asString(k.getId()), SystemLabel::getLabelName, (o, n) -> n));

            for (Map<String, Object> item : dataList) {
                final String addLabels = GeneralUtil.asString(item.get(ReleationConstants.SYSTEM_LABEL_ID));
                String names = null;
                if (StringUtils.isNotBlank(addLabels)) {
                    names = Arrays.stream(StringUtils.split(addLabels, ","))
                        .map(labelId -> Optional.ofNullable(labelMap.get(labelId)).orElse(null))
                        .collect(Collectors.joining(","));
                }
                item.put(LABEL_NAME, names);
            }
        }
        return result;
    }

    public boolean containsKey(ConditionQueryRequest queryRequest, String key) {
        final List<String> fields = queryRequest.getEntity().getFields();
        return fields.contains(key);
    }

}

