package com.xforceplus.elephant.image.servicehandler.export;

import akka.NotUsed;
import akka.stream.javadsl.Source;
import com.xforceplus.elephant.basecommon.dispatch.BeanDispatcher;
import com.xforceplus.elephant.basecommon.system.paas.OrgUtils;
import com.xforceplus.elephant.image.core.business.application.config.common.service.DictionaryService;
import com.xforceplus.elephant.image.core.util.RequestParser;
import com.xforceplus.elephant.image.servicehandler.newbasebill.DefaultNewBaseBillService;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.BaseBill;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.ClassifiedRecord;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.ExportSource;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.impl.SequenceExportSource;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpBi;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpFactory;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpField;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpNode;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRange;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpSort;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpValue;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpVisitor;
import com.xforceplus.ultraman.starter.autoconfigure.SdkConfiguration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

/**
 * 单据导出二开
 *
 * @author rongying
 * @date 2021/6/7 17:48
 */
@Component
public class BaseBillExportSource implements ExportSource {

    private SequenceExportSource source;
    private OrgUtils orgUtils;
    private DictionaryService dictionaryService;
    private BeanDispatcher beanDispatcher;

    public BaseBillExportSource(EntityFacade entityFacade, ContextService contextService, SdkConfiguration sdkConfiguration, OrgUtils orgUtils, DictionaryService dictionaryService,
        BeanDispatcher beanDispatcher) {
        this.orgUtils = orgUtils;
        this.dictionaryService = dictionaryService;
        this.beanDispatcher = beanDispatcher;
        source = new SequenceExportSource(entityFacade, 1000, 3, contextService, sdkConfiguration.getExec());
    }

    @Override
    public boolean isAccept(IEntityClass iEntityClass, boolean isMultiSchema, Map<String, Object> map) {
        return !isMultiSchema && (iEntityClass.code().equals(EntityMeta.BaseBill.code()) || (iEntityClass.extendEntityClass() != null && iEntityClass.extendEntityClass().code()
            .equals(EntityMeta.BaseBill.code())));
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }

    class StatusVisitor implements ExpVisitor<Void> {

        private String status;

        private String type;

        public StatusVisitor(String type) {
            this.type = type;
        }

        public String getStatus() {
            return status;
        }

        @Override
        public Void visit(ExpField expField) {
            return null;
        }

        @Override
        public Void visit(ExpCondition expCondition) {
            if (expCondition.getOperator() != ExpOperator.AND && expCondition.getOperator() != ExpOperator.OR) {
                final Optional<ExpNode> fieldNode = expCondition.getExpNodes().stream().filter(x -> x instanceof ExpField).findFirst();
                if (fieldNode.isPresent()) {
                    //判断单据状态
                    if (((ExpField) fieldNode.get()).getName().equals("bill_data_status")) {
                        final Optional<ExpNode> value = expCondition.getExpNodes().stream().filter(x -> x instanceof ExpValue).findFirst();
                        if (value.isPresent()) {
                            final ExpValue expValue = (ExpValue) value.get();
                            status = expValue.getStrValue();
                        }
                    }
                }
            } else {
                expCondition.getExpNodes().stream().forEach(x -> x.accept(this));
            }
            return null;
        }

        @Override
        public Void visit(ExpValue expValue) {
            return null;
        }

        @Override
        public Void visit(ExpBi expBi) {
            return null;
        }

        @Override
        public Void visit(ExpSort expSort) {
            return null;
        }

        @Override
        public Void visit(ExpRange expRange) {
            return null;
        }

    }

    @Override
    public Source<ClassifiedRecord, NotUsed> source(String classifier, IEntityClass iEntityClass, ExpRel query, Map<String, ExpRel> subQuery, long maxRecord, Map<String, Object> context) {
        //获取页面pageCode
        final String pageCode = (String) context.get("PAGE");
        //解析condition,拿到单据状态值
        final StatusVisitor statusVisitor = new StatusVisitor(pageCode);
        query.accept(statusVisitor);
        //获取二开条件
        final ToConditionQueryRequest toConditionQueryRequest = new ToConditionQueryRequest();
        query.accept(toConditionQueryRequest);
        final ConditionQueryRequest request = toConditionQueryRequest.getConditionQueryRequest();
        wrapper(UserInfoHolder.get(), pageCode, request);

        query.getFilters().clear();
        final ExpQuery additionalExp = ExpFactory.createFrom(request);
        query.getFilters().addAll(additionalExp.getFilters());

        final DefaultNewBaseBillService service = beanDispatcher.dispatch(UserInfoHolder.get().getTenantId(), DefaultNewBaseBillService.class);
        return source.source(Optional.ofNullable(classifier).orElse(iEntityClass.code()), iEntityClass, query, subQuery, maxRecord, context)
            .map(record -> service.wrapper(record));
    }

    @Override
    public int compareTo(ExportSource o) {
        return 0;
    }

    /**
     * 获取二开条件
     *
     * @param user     用户
     * @param pageCode 页面代码
     * @param request  条件
     * @return com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest
     * @author rongying
     * @date 2021/6/8 11:15
     */
    private void wrapper(IAuthorizedUser user, String pageCode, ConditionQueryRequest request) {
        final RequestParser requestParser = RequestParser.parse(request);
        final boolean flag = beanDispatcher.dispatch(user.getTenantId(), DefaultNewBaseBillService.class)
            .handleConditionSearch(user, pageCode, request);
        if (!flag) {
            //此处不知如何返回空数据，给一个必为false的条件
            requestParser.field(BaseBill.ORG_ID.code(), ConditionOp.eq, "-1");
        }
    }

    private ConditionQueryRequest parse(ExpRel query) {
        final ConditionQueryRequest request = new ConditionQueryRequest();
        final RequestParser requestParser = RequestParser.parse(request);
        query.getFilters().forEach(expNode -> {
            final ExpCondition condition = (ExpCondition) expNode;
            condition.getExpNodes().forEach(en -> {
                final ExpCondition cd = (ExpCondition) en;
                final String field = cd.getExpNodes().stream().filter(n -> n instanceof ExpField).map(f -> ((ExpField) f).getName()).findFirst().orElse("");
                final List<String> values = cd.getExpNodes().stream().filter(n -> n instanceof ExpValue).map(v -> ((ExpValue) v).getStrValue()).collect(Collectors.toList());
                requestParser.field(field, cd.getOperator().getOp(), values);
            });
        });
        return request;
    }

}
