package com.xforceplus.elephant.image.servicehandler.export;

import static com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator.AND;
import static com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator.OR;

import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Conditions;
import com.xforceplus.ultraman.metadata.domain.vo.dto.FieldCondition;
import com.xforceplus.ultraman.metadata.domain.vo.dto.FieldSort;
import com.xforceplus.ultraman.metadata.domain.vo.dto.SubFieldCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpBi;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpField;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRange;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpSort;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpValue;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ToConditionQueryRequest implements ExpVisitor<Void> {

    ConditionQueryRequest conditionQueryRequest = new ConditionQueryRequest();
    Conditions conditions = new Conditions();
    List<FieldCondition> fieldsConditions = new ArrayList<>();
    List<SubFieldCondition> subFields = new ArrayList<>();
    List<FieldSort> sorts = new ArrayList<>();

    public ToConditionQueryRequest() {
        conditions.setFields(fieldsConditions);
        conditions.setEntities(subFields);
        conditionQueryRequest.setConditions(conditions);
        conditionQueryRequest.setSort(sorts);
    }

    public ConditionQueryRequest getConditionQueryRequest() {
        return conditionQueryRequest;
    }

    @Override
    public Void visit(ExpField field) {
        return null;
    }

    @Override
    public Void visit(ExpCondition rel) {
        if (rel.getOperator() == AND) {
            rel.getExpNodes().forEach(x -> x.accept(this));
        } else if (rel.getOperator() == OR) {
            throw new RuntimeException("Cannot revert a exprel to conditionQueryRequest");
        } else {
            final List<ExpField> fields = rel.getExpNodes().stream()
                .filter(x -> x instanceof ExpField)
                .map(x -> (ExpField) x)
                .collect(Collectors.toList());
            final List<ExpValue> expValues = rel.getExpNodes().stream()
                .filter(x -> x instanceof ExpValue)
                .map(x -> (ExpValue) x)
                .collect(Collectors.toList());
            if (fields.size() == 1) {
                final ExpField expField = fields.get(0);
                final String name = expField.getName();
                if (name.startsWith("_")) {
                    //sub
                    final String[] split = name.split("\\.");
                    if (split.length == 2) {
                        final String code = split[0].substring(1);
                        final String fieldName = split[1];
                        final SubFieldCondition subFieldCondition;
                        final Optional<SubFieldCondition> first = subFields.stream().filter(sub -> sub.getCode().equals(code)).findFirst();
                        if (first.isPresent()) {
                            subFieldCondition = first.get();
                        } else {
                            subFieldCondition = new SubFieldCondition();
                            subFieldCondition.setCode(code);
                            subFieldCondition.setFields(new ArrayList<>());
                            subFields.add(subFieldCondition);
                        }
                        final FieldCondition fieldCondition = new FieldCondition();
                        fieldCondition.setCode(fieldName);
                        fieldCondition.setValue(expValues.stream().map(v -> v.getStrValue()).collect(Collectors.toList()));
                        fieldCondition.setOperation(rel.getOperator().getOp());
                        subFieldCondition.getFields().add(fieldCondition);
                    }
                } else {
                    //main
                    final FieldCondition fieldCondition = new FieldCondition();
                    fieldCondition.setCode(name);
                    fieldCondition.setValue(expValues.stream().map(v -> v.getStrValue()).collect(Collectors.toList()));
                    fieldCondition.setOperation(rel.getOperator().getOp());
                    fieldsConditions.add(fieldCondition);
                }
            } else {
                throw new RuntimeException("clause is not simple");
            }
        }
        return null;
    }

    @Override
    public Void visit(ExpValue value) {
        return null;
    }

    @Override
    public Void visit(ExpBi bi) {
        return null;
    }

    @Override
    public Void visit(ExpSort expSort) {
        if (expSort != null) {
            final List<FieldSort> collect = Optional.ofNullable(expSort.getSorts()).orElseGet(Collections::emptyList).stream().map(x -> {
                final String code = x.getCode();
                final String aShort = x.getSort().getShort();
                final FieldSort sort = new FieldSort();
                sort.setField(code);
                sort.setOrder(aShort);
                return sort;
            }).collect(Collectors.toList());
            sorts.addAll(collect);
        }
        return null;
    }

    @Override
    public Void visit(ExpRange range) {
        if (range != null) {
            conditionQueryRequest.setPageNo(range.getIndex());
            conditionQueryRequest.setPageSize(range.getSize());
        }
        return null;
    }

}