package com.xforceplus.elephant.image.servicehandler.newbasebill;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.enums.common.PageCodeEnum;
import com.xforceplus.elephant.basecommon.system.paas.OrgUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.business.application.config.common.service.DictionaryService;
import com.xforceplus.elephant.image.core.util.RequestParser;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.BaseBill;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.ClassifiedRecord;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

/**
 * @Description: 重庆医药单据相关页面二开条件查询实现
 * @Author liming
 * @Date 2020/8/26 20:16
 */
@Dispatch(tenantCode = "CQP")
@Service
public class CQPNewBaseBillService extends DefaultNewBaseBillService {

    public CQPNewBaseBillService(OrgUtils orgUtils, DictionaryService dictionaryService) {
        super(orgUtils, dictionaryService);
    }

    @Override
    public boolean customConditionSearch(final IAuthorizedUser user, final String pageCode, final RequestParser requestParser) {
        final List<String> billStatus = requestParser.value(BaseBill.BILL_DATA_STATUS.code());
        if (PageCodeEnum.SCAN.getCode().equals(pageCode)) {
            //退回状态时把image_id>0条件去掉 YXDA-4186
            if (ValidatorUtil.isNotEmpty(billStatus)
                && BillDataStatus._4.getCode().equals(billStatus.get(0))) {
                requestParser.removeField(BaseBill.IMAGE_ID.code());
            }
            requestParser.field(BaseBill.SCAN_USER_ID.code(), ConditionOp.eq, user.getId());
            if (ValidatorUtil.isNotEmpty(billStatus) && !BillDataStatus._0.getCode().equals(billStatus.get(0))) {
                requestParser.sort(BaseBill.BILL_DATA_TIME.code(), "desc");
            } else {
                requestParser.sort(BaseBill.SCAN_CREATE_TIME.code(), "desc");
            }
        } else if (PageCodeEnum.ALL_BILL_POOL.getCode().equals(pageCode)) {
            //退回状态时把image_id>0条件去掉 YXDA-4186
            if (ValidatorUtil.isNotEmpty(billStatus)
                && BillDataStatus._4.getCode().equals(billStatus.get(0))) {
                requestParser.removeField(BaseBill.IMAGE_ID.code());
            }
            if (ValidatorUtil.isNotEmpty(billStatus) && !BillDataStatus._0.getCode().equals(billStatus.get(0))) {
                requestParser.sort(BaseBill.BILL_DATA_TIME.code(), "desc");
            } else {
                requestParser.sort(BaseBill.SCAN_CREATE_TIME.code(), "desc");
            }
        }
        return true;
    }

    @Override
    public ClassifiedRecord wrapper(ClassifiedRecord record) {
        final Map<String, Object> recordMap = record.getRecord().toMap(Collections.emptySet());
        final JSONObject bill = new JSONObject(recordMap);
        final String backType = bill.getString(EntityMeta.BaseBill.BACK_TYPE.code());
        final BackType backTypeEnum = BackType.fromCode(backType);
        if (backTypeEnum != null && backTypeEnum != BackType._0) {
            record.getRecord().set(EntityMeta.BaseBill.ID.code(), "1");
        } else {
            record.getRecord().set(EntityMeta.BaseBill.ID.code(), "");
        }
        return record;
    }

}
