package com.xforceplus.elephant.image.servicehandler.newbasebill;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.enums.common.PageCodeEnum;
import com.xforceplus.elephant.basecommon.system.paas.OrgUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.business.application.config.common.service.DictionaryService;
import com.xforceplus.elephant.image.core.util.RequestParser;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.BaseBill;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.ClassifiedRecord;
import java.util.List;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @Description 默认单据相关页面二开条件查询实现
 * @Author liming
 * @Date 2020/8/26 20:00
 */
@Dispatch(isDefault = true)
@Service
@RequiredArgsConstructor
public class DefaultNewBaseBillService {

    private final OrgUtils orgUtils;
    private final DictionaryService dictionaryService;

    /**
     * 定制条件
     *
     * @param user          当前登陆人
     * @param pageCode      页面code
     * @param requestParser 请求
     * @return 是否继续
     */
    public boolean customConditionSearch(final IAuthorizedUser user, final String pageCode, final RequestParser requestParser) {
        if (PageCodeEnum.SCAN.getCode().equals(pageCode)) {
            final List<String> billStatus = requestParser.value(BaseBill.BILL_DATA_STATUS.code());
            requestParser.field(BaseBill.SCAN_USER_ID.code(), ConditionOp.eq, user.getId());
            if (ValidatorUtil.isNotEmpty(billStatus) && !BillDataStatus._0.getCode().equals(billStatus.get(0))) {
                requestParser.sort(BaseBill.BILL_DATA_TIME.code(), "desc");
            } else {
                requestParser.sort(BaseBill.SCAN_CREATE_TIME.code(), "desc");
            }
        }
        return true;
    }

    /**
     * 标准条件
     *
     * @param user     当前登陆人
     * @param pageCode 页面code
     * @param request  请求
     * @return 是否继续
     */
    public boolean handleConditionSearch(final IAuthorizedUser user, final String pageCode, final ConditionQueryRequest request) {
        final RequestParser requestParser = RequestParser.parse(request);
        requestParser.removeField("page_code");
        //定制条件
        final boolean flag = customConditionSearch(user, pageCode, requestParser);
        if (!flag) {
            return false;
        }
        //权限查询
        if (dictionaryService.isOpenOrgQuery(pageCode, user.getTenantId(), user.getTenantCode())) {
            final List<Long> orgIds = orgUtils.getCurrentUserOrgIds(user.getTenantId(), user.getId());
            if (ValidatorUtil.isEmpty(orgIds)) {
                return false;
            }
            requestParser.field(BaseBill.ORG_ID.code(), ConditionOp.in, orgIds);
        }
        return true;
    }

    /**
     * 导出映射
     *
     * @param record 行记录
     * @return 行记录
     */
    public ClassifiedRecord wrapper(ClassifiedRecord record) {
        return record;
    }

}
