package com.xforceplus.elephant.image.controller.batchnumberrule.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.HashMap;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class GetRuleCodeConfigProcess {

    @Autowired
    private ConfigService configService;

    private JSONObject getAllConfig() {

        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        try {
            final String configJson = configService.selectDict(authorizedUser.getTenantId(), DictEnum.BATCH_NUMBER_RULE_CONFIG.getCode());
            final JSONObject configJsonObject = JSONObject.parseObject(configJson);
            return configJsonObject;
        } catch (ValidationException e) {
            throw new ValidationException("规则字典配置异常");
        }
    }

    public CommonResponse<JSONArray> getRuleCodeConfig() {
        try {
            final JSONObject configJsonObject = getAllConfig();
            final JSONArray ruleCodeConfig = configJsonObject.getJSONArray("code");
            return CommonResponse.ok("成功", ruleCodeConfig);
        } catch (Exception e) {
            throw new ValidationException("规则字典配置异常");
        }
    }

    public CommonResponse<JSONArray> getEnumsConfig() {
        try {
            final JSONObject configJsonObject = getAllConfig();
            final JSONArray enumsConfig = configJsonObject.getJSONArray("enums");
            return CommonResponse.ok("成功", enumsConfig);
        } catch (Exception e) {
            throw new ValidationException("规则字典配置异常");
        }
    }

    public CommonResponse<JSONArray> getEnumDetailsConfig(String enumValue) {
        try {
            final JSONObject configJsonObject = getAllConfig();
            final JSONArray enumDetailsConfig = configJsonObject.getJSONObject("enumDetails").getJSONArray(enumValue);
            return CommonResponse.ok("成功", enumDetailsConfig);
        } catch (Exception e) {
            throw new ValidationException("规则字典配置异常");
        }
    }

    public CommonResponse<Map<String, JSONArray>> getEnumDetailsConfig(String[] enumValues) {
        try {
            final Map<String, JSONArray> map = new HashMap<>();
            for (String enumValue : enumValues) {
                final JSONObject configJsonObject = getAllConfig();
                final JSONArray enumDetailsConfig = configJsonObject.getJSONObject("enumDetails").getJSONArray(enumValue);
                map.put(enumValue, enumDetailsConfig);
            }
            return CommonResponse.ok("成功", map);
        } catch (Exception e) {
            throw new ValidationException("规则字典配置异常");
        }
    }

}
