package com.xforceplus.elephant.image.controller.billdata.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.system.paas.OrgUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetOrgExtensionsProcess extends AbstractProcess<BaseRequest, JSONObject> {

    @Autowired
    private OrgUtils orgUtils;

    @Override
    protected CommonResponse<JSONObject> process(BaseRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final Map<String, String> params = new HashMap<>();
        params.put("tenantId", authorizedUser.getTenantId().toString());
        params.put("userId", authorizedUser.getId().toString());
        params.put("withExtendParams", "extensions");
        final JSONArray array = orgUtils.getOrgs(authorizedUser.getTenantId(), params);
        final JSONObject result = new JSONObject();
        for (int i = 0; i < array.size(); i++) {
            final JSONObject org = array.getJSONObject(i);
            final JSONArray extensions = org.getJSONArray("extensions");
            if (ValidatorUtil.isEmpty(extensions)) {
                continue;
            }
            for (int j = 0; j < extensions.size(); j++) {
                final JSONObject extension = extensions.getJSONObject(j);
                if (1 != extension.getIntValue("status")) {
                    continue;
                }
                if (!"billEntityCode".equals(extension.getString("extensionKey"))) {
                    continue;
                }
                try {
                    final JSONObject billEntityCode = JSON.parseObject(extension.getString("extensionValue"));
                    result.putAll(billEntityCode);
                    break;
                } catch (Exception e) {
                    logger.error("组织扩展字段【billEntityCode】配置异常: " + extension.getString("extensionValue"), e);
                }
            }
        }
        return CommonResponse.ok("成功", result);
    }

}
