package com.xforceplus.elephant.image.controller.check.process;

import com.alibaba.fastjson.JSON;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.core.business.application.calculate.check.config.CheckConfigDTO;
import com.xforceplus.elephant.image.core.business.application.calculate.check.config.CheckConfigService;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.facade.adapter.usercenter.UserCenterFacade;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CheckCategory;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CheckGroup;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.CheckDisplayText;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.CheckSystemConfig;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.CheckUserConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@Slf4j
@RequiredArgsConstructor
public class CheckDataInitProcess extends AbstractProcess<BaseRequest, Boolean> {

    public static final String USER_CONFIG_DICT = "check_ticket_user_config";
    public static final String SYSTEM_CONFIG_DICT = "check_ticket_system_config";

    public static final List<String> SENSITIVE_LIST = Arrays.asList("person_check", "repeat_check", "blacklist_check", "sensitive_check", "consecutive_check", "ticket_remark_check");
    public static final List<String> HOOK_LIST = Arrays.asList("title_check", "sales_list_check", "used_amount_check");

    private final CheckConfigService checkConfigService;
    private final ConfigService configService;
    private final UserCenterFacade userCenterFacade;
    private final CheckConfigDTOMapper checkConfigMapper;

    @Override
    protected CommonResponse<Boolean> process(BaseRequest request) throws RuntimeException {
        final Map<Long, List<CheckConfigDTO>> userConfigMap = configService.selectDictByDictCode(USER_CONFIG_DICT)
            .entrySet()
            .stream().collect(Collectors.toMap(entry -> entry.getKey(), entry -> JSON.parseArray(entry.getValue(), CheckConfigDTO.class), (o1, o2) -> o1, TreeMap::new));
        userConfigMap.forEach((tenantId, userConfigs) -> {
            final String tenant = tenantId != 0L ? userCenterFacade.getTenantByTenantId(tenantId).orElse(new TenantDto()).getTenantCode() : null;
            final boolean isStandard = tenantId == 0L;
            userConfigs.forEach(configDTO -> {
                final CheckUserConfig userConfig = checkConfigMapper.userMapping(configDTO);
                userConfig.setCategory(CheckCategory.TICKET.getCode());
                userConfig.setTenant(tenant);
                userConfig.setIsStandard(isStandard);
                if (SENSITIVE_LIST.contains(userConfig.getCode())) {
                    userConfig.setGroup(CheckGroup._2.getCode());
                } else if (HOOK_LIST.contains(userConfig.getCode())) {
                    userConfig.setGroup(CheckGroup._3.getCode());
                } else {
                    userConfig.setGroup(CheckGroup._1.getCode());
                }
                checkConfigService.save(userConfig);

                configDTO.getDisplayTexts().forEach((key, word) -> {
                    final CheckDisplayText displayText = new CheckDisplayText();
                    displayText.setCategory(CheckCategory.TICKET.getCode());
                    displayText.setTenant(tenant);
                    displayText.setIsStandard(isStandard);
                    displayText.setCode(userConfig.getCode());
                    displayText.setKey(key);
                    displayText.setWord(word);
                    checkConfigService.save(displayText);
                });
            });
        });

        final Map<Long, List<CheckConfigDTO>> systemConfigMap = configService.selectDictByDictCode(SYSTEM_CONFIG_DICT)
            .entrySet()
            .stream().collect(Collectors.toMap(entry -> entry.getKey(), entry -> JSON.parseArray(entry.getValue(), CheckConfigDTO.class), (o1, o2) -> o1, TreeMap::new));
        systemConfigMap.forEach((tenantId, systemConfigs) -> {
            final String tenant = tenantId != 0L ? userCenterFacade.getTenantByTenantId(tenantId).orElse(new TenantDto()).getTenantCode() : null;
            final boolean isStandard = tenantId == 0L;
            systemConfigs.forEach(configDTO -> {
                final CheckSystemConfig systemConfig = checkConfigMapper.systemMapping(configDTO);
                systemConfig.setCategory(CheckCategory.TICKET.getCode());
                systemConfig.setTenant(tenant);
                systemConfig.setIsStandard(isStandard);
                checkConfigService.save(systemConfig);
            });
        });
        return CommonResponse.ok("成功");
    }

}
