package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetDetailResourceCodeRequest;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.facade.application.config.dictionary.DictionaryFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareGetDetailResourceCodeProcess extends AbstractProcess<GetDetailResourceCodeRequest, List<String>> {

    @Autowired
    private CompareBaseBillService baseBillService;
    @Autowired
    private DictionaryFacade dictionaryFacade;

    @Override
    protected void check(GetDetailResourceCodeRequest request) throws ValidationException {
        if (ValidatorUtil.isEmpty(request.getBillCode())) {
            checkEmpty(request.getBillCode(), "billCode不能为空");
        }
        if (ValidatorUtil.isEmpty(request.getPageCode())) {
            checkEmpty(request.getPageCode(), "pageCode不能为空");
        }
    }

    @Override
    protected CommonResponse<List<String>> process(GetDetailResourceCodeRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final BaseBill baseBill = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(), request.getBillCode());
        final List<String> resources = dictionaryFacade.getBillDetailResourceList(authorizedUser.getTenantId(), request.getPageCode(), request.getScene(), baseBill);
        return CommonResponse.ok("", resources);
    }

}
