package com.xforceplus.elephant.image.controller.compare.image.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.FileUtils;
import com.xforceplus.elephant.basecommon.help.RandomUtil;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.InsertBillImageRequest;
import com.xforceplus.elephant.image.client.model.InsertImageDTO;
import com.xforceplus.elephant.image.core.business.application.collect.batch.domain.EnableFlowContext;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.elephant.image.core.business.application.collect.task.domain.FileTransformTypeConfig;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.FileTypeEnum;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.business.util.LogUtil;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.domain.imagefile.ImageFileService;
import com.xforceplus.elephant.image.core.facade.application.collect.bill.BillFacade;
import com.xforceplus.elephant.image.core.facade.application.collect.upload.UploadFacade;
import com.xforceplus.elephant.image.core.facade.application.compare.collect.upload.CompareUploadFacade;
import com.xforceplus.elephant.image.core.facade.dto.upload.UploadImageDto;
import com.xforceplus.elephant.image.core.facade.dto.upload.UploadImageRequestDto;
import com.xforceplus.elephant.image.core.repository.model.BatchTaskEntity;
import com.xforceplus.elephant.image.core.util.ImageUtils;
import com.xforceplus.elephant.image.listener.MqQueueSizeListener;
import com.xforceplus.elephant.image.mapper.UploadMapper;
import com.xforceplus.purchaser.bizratelimiter.model.Application;
import com.xforceplus.purchaser.bizratelimiter.model.BizRequest;
import com.xforceplus.purchaser.bizratelimiter.model.Channel;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.*;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ImageFile;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.xlog.core.model.LogContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.groovy.util.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @author yuhongxia
 * @description 补扫单据下的单证
 * @date 2021/5/8 17:06
 */
@Service
public class CompareInsertBillImageProcess extends AbstractProcess<InsertBillImageRequest, List<Long>> {

    @Autowired
    private BillFacade billFacade;
    @Autowired
    private ImageFileService imageFileService;
    @Autowired
    private CompareUploadFacade compareUploadFacade;
    @Autowired
    private UploadFacade uploadFacade;
    @Autowired
    private UploadMapper uploadMapper;
    @Autowired
    private ConfigSettingsService configSettingsService;
    @Autowired
    private BatchService batchService;
    @Autowired
    private MQUtils mqUtils;
    @Autowired(required = false)
    private Application application;

    @Value("${image.pdfQueue.threshold:1000}")
    private int pdfQueueSize;
    @Value("${image.pdfQueue.tpm:90}")
    private int pdfQueueTpm;
    @Value("${image.pdfQueue.tips:当前pdf转换队列已积压%s条，预估等到时间%s分钟}")
    private String pdfQueueTips;

    @Override
    protected void check(InsertBillImageRequest request) throws ValidationException {
        checkEmpty(request.getBillCode(), "单据CODE不能为空");
        if (CollectionUtils.isEmpty(request.getInsertImageDTOList()) && CollectionUtils.isEmpty(request.getInsertAttachmentImageDTOList())) {
            throw new ValidationException("操作对象不能为空");
        }
        if (CollectionUtils.isNotEmpty(request.getInsertImageDTOList())) {
            for (InsertImageDTO entity : request.getInsertImageDTOList()) {
                checkEmpty(entity.getFileStream(), "文件流不能为空");
                checkEmpty(entity.getFileType(), "文件类型不能为空");
                final FileTypeEnum fileTypeEnum = FileTypeEnum.fromCode(entity.getFileType());
                checkEmpty(fileTypeEnum, "不支持该类型文件" + entity.getFileType());
            }
        }
        if (CollectionUtils.isNotEmpty(request.getInsertAttachmentImageDTOList())) {
            for (final InsertImageDTO entity : request.getInsertAttachmentImageDTOList()) {
                checkEmpty(entity.getFileStream(), "文件流不能为空");
                checkEmpty(entity.getFileType(), "文件类型不能为空");
                final FileTypeEnum fileTypeEnum = FileTypeEnum.fromCode(entity.getFileType());
                checkEmpty(fileTypeEnum, "不支持该类型文件" + entity.getFileType());
            }
        }
    }

    @Override
    protected CommonResponse<List<Long>> process(InsertBillImageRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final BaseBill billEntity = billFacade.selectBaseBillByCode(user.getTenantId(), request.getBillCode(), EntityMeta.CompareBaseBill.code());
        if (ValidatorUtil.isEmpty(billEntity)) {
            return CommonResponse.failed("上传失败,该单据不存在!");
        }
        if (!Arrays.asList(BillDataStatus._0.getCode(), BillDataStatus._2.getCode(), BillDataStatus._6.getCode(), BillDataStatus._4.getCode())
                   .contains(billEntity.getBillDataStatus())) {
            return CommonResponse.failed("单据非待提交/暂挂起/已提交/已退回状态不可补扫上传影像");
        }
        final String batchNo = System.currentTimeMillis() + String.valueOf(RandomUtil.randomInt(99999));
        final String[] isPublic = {ValidatorUtil.isNotEmpty(billEntity.getIsPublic()) ? billEntity.getIsPublic() : ""};
        if (ValidatorUtil.isNotEmpty(request.getIsPublic())) {
            isPublic[0] = request.getIsPublic();
        }
        //1-获取当前补扫影像
        final Image parentImage = uploadFacade.getInsertImage(user.getTenantId(), request.getParentImageId(), request.getBillCode(), EntityMeta.CompareImage.code());
        final String[] fileOrder = {""};
        if (parentImage != null) {
            fileOrder[0] = parentImage.getFileOrder();
            //1-2补扫更新父影像fileOrder
            uploadFacade.updateFileOrder(parentImage.getId(), fileOrder[0], request.getInsertImageDTOList().size(), EntityMeta.CompareImage.code());
        }
        //2-获取文件转换字典配置
        final FileTransformTypeConfig fileTransformTypeConfig = imageFileService.getFileTransformTypeConfig(user.getTenantId());
        //3-上传
        final List<Long> imageIds = new ArrayList<>();
        final AtomicInteger index = new AtomicInteger();
        //3-0 存在zip，解析完在上传
        final UploadImageRequestDto requestDto = uploadMapper.map(request);
        uploadFacade.initSystemField(requestDto, user);
        final List<UploadImageDto> resultList = uploadFacade.checkZipFile(requestDto.getUploadImageDtoList(), user.getTenantId());
        final List<UploadImageDto> resultAttachmentList = uploadFacade.checkZipFile(requestDto.getUploadAttachmentImageDtoList(), user.getTenantId());
        final List<String> failedList = new ArrayList<>();//上传失败文件
        //是否开启限流
        final EnableFlowContext context = new EnableFlowContext().setTenantId(user.getTenantId()).setUserId(user.getId());
        final boolean flag = batchService.enable(context);
        // 3-1处理发票和附件上传任务
        final int totalSize = resultList.size() + resultAttachmentList.size();
        final List<JSONObject> requestDtos = processUploadItems(request, billEntity, fileOrder, resultList, index, totalSize, requestDto, batchNo, isPublic,
            user, fileTransformTypeConfig, flag, imageIds, failedList, false);
        processUploadItems(request, billEntity, fileOrder, resultAttachmentList, index, totalSize, requestDto, batchNo, isPublic,
            user, fileTransformTypeConfig, flag, imageIds, failedList, true);
        // 限流
        LogContext.setLogPoint("enableFlow", flag);
        if (flag) {
            final String channelCode = batchService.getChannelCode(user.getTenantCode());
            final BatchTaskEntity batchTaskEntity = new BatchTaskEntity();
            batchTaskEntity.setTenantId(user.getTenantId());
            batchTaskEntity.setTenantCode(user.getTenantCode());
            batchTaskEntity.setCreateUserId(user.getId());
            batchTaskEntity.setCreateUserName(user.getUsername());
            batchTaskEntity.setCreateTime(new Date());
            batchTaskEntity.setTaskCount(resultList.size());
            batchTaskEntity.setChannelCode(channelCode);
            final Long batchId = batchService.insert(batchTaskEntity);
            requestDtos.forEach(dto -> {
                ((Image) dto.get("image")).setBatchNo(String.valueOf(batchId));
                ((ImageFile) dto.get("imageFile")).setBatchNo(String.valueOf(batchId));
            });
            final Map<String, Object> headers = new HashMap<>();
            headers.put(com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE, user.getTenantCode());
            headers.put("batchNo", batchId);
            headers.put("userInfo", JSONObject.toJSONString(user));
            final JSONObject message = new JSONObject();
            message.put("bill", billEntity);
            message.put("images", requestDtos);
            try {
                if (batchService.sendEnableFlow(context)) {
                    final Channel channel = application.loadChannel(channelCode);
                    final BizRequest bizRequest = BizRequest.builder()
                                                            .bizQuantity(batchTaskEntity.getTaskCount())
                                                            .properties(headers)
                                                            .body(message.toJSONString())
                                                            .attrs(Maps.of("queueName", MQEnum.COMPARE_INSERT_BILL_UPLOAD_SYNC_QUEUE))
                                                            .build();
                    channel.flowInRateLimit(bizRequest);
                } else {
                    mqUtils.sendByDirectExchange(MQEnum.COMPARE_INSERT_BILL_UPLOAD_SYNC_QUEUE, message.toJSONString(), headers);
                }
            } catch (Exception e) {
                LogContext.setLogPoint("enableFlowError", e.getMessage());
                logger.error("使用限流异常", e);
                LogContext.setLogPoint("error", String.format("使用限流异常:%s", e.getMessage()));
                mqUtils.sendByDirectExchange(MQEnum.COMPARE_INSERT_BILL_UPLOAD_SYNC_QUEUE, message.toJSONString(), headers);
            } finally {
                LogUtil.attachSaveCount(CollectionUtils.size(request.getInsertImageDTOList()));
            }
            return CommonResponse.ok("成功");
        }
        //AR单重算单据
        if (SettlementType.AR.getCode().equals(billEntity.getSettlementType())) {
            compareUploadFacade.reCheckBill(user.getTenantId(), user.getTenantCode(), billEntity.getBillCode(), "compareAR单上传重算单据");
        }
        if (ValidatorUtil.isNotEmpty(failedList)) {
            String message = String.format("共上传%d条，其中%d条上传成功，%d条上传失败", resultList.size(), resultList.size() - failedList.size(), failedList.size());
            logger.info("compareInsertBillImage上传失败【{}】", failedList.stream().collect(Collectors.joining(",")));
            if (failedList.size() == resultList.size()) {
                message = "上传失败!";
            }
            return CommonResponse.ok(message);
        }
        final Integer queueSize = MqQueueSizeListener.QUEUE_SIZE.get(MQEnum.IMAGE_PDF_TRANSFORM_CALLBACK_QUEUE);
        if (resultList.stream().anyMatch(dto -> FileTypeEnum.PDF.getCode().equals(dto.getFileType()))
            && queueSize != null && queueSize > pdfQueueSize) {
            return CommonResponse.ok(String.format(pdfQueueTips, queueSize, queueSize / pdfQueueTpm + 1), imageIds);
        }
        LogUtil.attachSaveCount(CollectionUtils.size(request.getInsertImageDTOList()));
        return CommonResponse.ok("上传成功!", imageIds);
    }

    /**
     * 初始化影像文件，影像，保存数据返回imageId集合
     * @return
     */
    private List<JSONObject> processUploadItems(InsertBillImageRequest request, BaseBill billEntity, String[] fileOrder, List<UploadImageDto> imageDtos, AtomicInteger index,
        int totalSize, UploadImageRequestDto requestDto, String batchNo, String[] isPublic, IAuthorizedUser user, FileTransformTypeConfig fileTransformTypeConfig,
        boolean flag, List<Long> imageIds, List<String> failedList, boolean isAttachment) {
        final List<JSONObject> requestDtos = new ArrayList<>();
        imageDtos.forEach(imageDto -> {
            final String newFileOrder = request.getParentImageId() != null
                ? (fileOrder[0] + ImageUtils.sequence(index.incrementAndGet(), totalSize))
                : ImageUtils.sequence(billEntity.getImageCount() + index.incrementAndGet());
            //3-1初始化影像文件
            final ImageFile imageFile = uploadFacade.initImageFile(requestDto);
            //3-2获取影像上传地址,存储 fileKey,fileName
            final String fileUrl = uploadFacade.getUploadImageUrl(user.getTenantId(), user.getId(), imageDto.getFileStream(), imageDto.getFileType(), imageFile);
            if (ValidatorUtil.isEmpty(fileUrl)) {
                failedList.add(imageDto.getFileName() + imageDto.getFileType());
                return;
            }
            final String fileSuffix = ValidatorUtil.isNotEmpty(FileUtils.getFileSuffix(fileUrl)) ? FileUtils.getFileSuffix(fileUrl) : imageDto.getFileType();
            imageFile.setFileSuffix(fileSuffix);
            imageFile.setFileUrl(fileUrl);
            imageFile.setAttachmentName(imageDto.getFileName());
            imageFile.setFileOrder(newFileOrder);
            imageFile.setIsPublic(isPublic[0]);
            imageFile.setBatchNo(batchNo);

            //3-3初始化影像
            final Image image = uploadFacade.initImage(requestDto);
            image.setFileUrl(fileUrl);
            image.setFileUrlHandle(fileUrl);
            image.setFileType(fileSuffix);
            image.setFileTypeHandle(fileSuffix);
            image.setFileOrder(newFileOrder);
            image.setIsPublic(isPublic[0]);
            image.setBatchNo(batchNo);
            image.setFileName(imageDto.getFileName());

            if (isAttachment) {
                imageFile.setIsTransform(YesNo._0.getCode());
                imageFile.setRequireOcrFlag(YesNo._0.getCode());
                image.setRecStatus(RecStatus._2.getCode());
                image.setRequireOcrFlag(YesNo._0.getCode());
                image.setCalculateStatus(CalculateStatus._1.getCode());
                image.setTicketCode(EntityMeta.CompareTicketAttachment.code());
                final Long imageId = compareUploadFacade.executeUploadAttachment(billEntity, fileSuffix, image, imageFile, fileTransformTypeConfig);
                if (ValidatorUtil.isNotEmpty(imageId)) {
                    imageIds.add(imageId);
                }
                return;
            }
            imageFile.setTransformScene(TransformScene.TRANS_REC.getCode());
            //3-4上传
            if (!flag) {
                final Long imageId = compareUploadFacade.executeUpload(billEntity, fileSuffix, image, imageFile, fileTransformTypeConfig);
                if (ValidatorUtil.isNotEmpty(imageId)) {
                    imageIds.add(imageId);
                }
                return;
            }
            final JSONObject dto = new JSONObject();
            dto.put("image", image);
            dto.put("imageFile", imageFile);
            requestDtos.add(dto);
        });
        return requestDtos;
    }

}
