package com.xforceplus.elephant.image.controller.compare.image.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.enums.image.ImageReservedEnum;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.ModifyIsPrintedRequest;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareModifyIsPrintedProcess extends AbstractProcess<ModifyIsPrintedRequest, Boolean> {

    @Autowired
    private CompareImageService imageService;
    @Autowired
    private CompareBaseBillService baseBillService;

    @Override
    protected void check(ModifyIsPrintedRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCode(), "需要更新的单据号不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(ModifyIsPrintedRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final BaseBill baseBill = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(),
            request.getBillCode());
        checkEmpty(baseBill, "单据不存在");
        final Image sellerImage = imageService.selectBillReservedImages(authorizedUser.getTenantId(),
            request.getBillCode(), ImageReservedEnum.RESERVED2, YesNo._1.getCode().toString())
            .stream().findFirst().orElse(null);
        checkEmpty(sellerImage, "该单据下不存在发票清单");
        final String isPrinted = YesNo.fromCode(request.getIsPrinted()) == null ? YesNo._1.getCode() : request.getIsPrinted();
        final JSONObject billUpdate = new JSONObject();
        billUpdate.put("reserved3", isPrinted.toString());
        boolean flag = baseBillService.updateByBillIdSelective(baseBill.getId(), billUpdate) > 0;
        final Image imageUpdate = new Image();
        imageUpdate.setId(sellerImage.getId());
        imageUpdate.setReserved3(isPrinted.toString());
        flag = flag && imageService.updateImageSelective(imageUpdate);
        if (flag) {
            return CommonResponse.ok("成功", true);
        }
        return CommonResponse.failed("更新失败");
    }

}
