package com.xforceplus.elephant.image.controller.compare.image.process;

import com.google.common.collect.Lists;
import com.xforceplus.elephant.basecommon.enums.image.ImageReturnStatusEnum;
import com.xforceplus.elephant.basecommon.enums.log.LogOperateTypeEnum;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.ReturnImageRequest;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.domain.image.ImageReturnService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompareReturnImageProcess extends AbstractProcess<ReturnImageRequest, Boolean> {

    @Autowired
    private CompareImageService imageService;
    @Autowired
    private CompareBaseBillService baseBillService;
    @Autowired
    private ImageReturnService imageBackService;

    @Override
    protected void check(ReturnImageRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getImageIds())) {
            throw new ValidationException("影像ID集合【imageIds】不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(ReturnImageRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final List<Image> imageList = imageService.selectImages(authorizedUser.getTenantId(), request.getImageIds());
        if (CollectionUtils.isEmpty(imageList)) {
            return CommonResponse.failed("没有找到影像数据");
        }
        //单据是否退回
        boolean billReturn = false;
        String backType = BackType._0.getCode();
        if (!StringHelp.safeIsEmpty(request.getBillCode())) {
            final BaseBill billEntity = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(), request.getBillCode());
            if (null != billEntity && BillDataStatus._4.getCode().equals(billEntity.getBillDataStatus())) {
                billReturn = true;
                backType = billEntity.getBackType();
            }
        }
        final List<Long> imageIds = Lists.newArrayList();
        for (Image image : imageList) {
            if (BackType._0.getCode().equals(image.getReturnStatus())
                || (billReturn && BackStatus._2.getCode().equals(image.getReturnStatus()))) {
                imageIds.add(image.getId());
            }
        }
        if (CollectionUtils.isEmpty(imageIds)) {
            return CommonResponse.failed("没有找到可退回打标记的影像数据");
        }
        final boolean result = imageService.updateImageBackStatus(authorizedUser.getTenantId(), imageIds,
            BackType._1.getCode(), request.getReturnReason(), request.getReturnRemark(),
            authorizedUser.getId(), authorizedUser.getUsername());
        //添加退回记录
        if (billReturn) {
            for (Long id : imageIds) {
                imageBackService.insertImageBack(imageBackService
                    .setImageReturnEntity(authorizedUser.getTenantId(), "", id, backType, request.getReturnReason(), request.getReturnRemark(), authorizedUser.getId(), authorizedUser.getUsername(),
                        false, LogOperateTypeEnum.BACK.getCode(), "", "", ""));
            }
        }
        String message = "退回打标记成功";
        if (imageIds.size() != request.getImageIds().size()) {
            message = String.format("%d条记录成功退回打标记%d条", request.getImageIds().size(), imageIds.size());
        }
        return CommonResponse.ok(message, result);
    }

}
