package com.xforceplus.elephant.image.controller.compare.ticket.process;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.ClearTicketDataRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.domain.compare.ticket.CompareTicketService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.HashMap;
import java.util.Map;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareClearTicketDataProcess extends AbstractProcess<ClearTicketDataRequest, Boolean> {

    @Autowired
    private CompareTicketService ticketService;
    @Autowired
    private CompareBillImageTicketService billImageTicketService;
    @Autowired
    private MQUtils rabbitmqUtils;

    @Override
    protected void check(ClearTicketDataRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getTicketId())) {
            throw new ValidationException("单证ID【ticketId】不能为空");
        }
        if (ValidatorUtil.isEmpty(request.getTicketCode())) {
            throw new ValidationException("单证code【ticketCode】不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(ClearTicketDataRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final Map<String, Object> objectMap = ticketService.selectByTicketCode(request.getTicketCode(), request.getTicketId());
        if (null == objectMap) {
            return CommonResponse.failed("没有查询到单证数据.");
        }
        final int count = ticketService.deleteTicketByCode(request.getTicketCode(), request.getTicketId());
        if (count > 0) {
            //重算多票
            if (objectMap.containsKey("image_id")) {
                final Long imageId = Long.valueOf(objectMap.get("image_id").toString());
                billImageTicketService.updateManyExceWarnData(imageId);
                billImageTicketService.updateImageExceWarnData(authorizedUser.getTenantId(), imageId);
            }
            if (objectMap.get("bill_code") != null && !StringHelp.safeIsEmpty(objectMap.get("bill_code").toString())) {
                final Map<String, Object> paramMap = Maps.newHashMap();
                paramMap.put("tenantId", objectMap.get("tenant_id"));
                paramMap.put("billCode", objectMap.get("bill_code").toString());
                paramMap.put("source", "单证结构数据清除重算单据");
                final Map<String, Object> headers = new HashMap<>();
                headers.put(TENANT_CODE, authorizedUser.getTenantCode());
                rabbitmqUtils.sendByDirectExchange(MQEnum.COMPARE_BILL_TICKET_EXCEPTION_QUEUE, paramMap, headers);
            }
            return CommonResponse.ok("删除成功", true);
        } else {
            return CommonResponse.failed("无记录删除");
        }
    }

}