package com.xforceplus.elephant.image.controller.image;

import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.UploadImageApi;
import com.xforceplus.elephant.image.client.model.UploadFile;
import com.xforceplus.elephant.image.core.business.infrastructure.port.FileService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.ArrayList;
import java.util.List;
import lombok.RequiredArgsConstructor;
import org.springframework.web.multipart.MultipartFile;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2025/3/10 16:51
 */
@RequiredArgsConstructor
@ApiV1Image
public class UploadImageController implements UploadImageApi {

    private final FileService fileService;

    @Override
    public CommonResponse<List<UploadFile>> uploadPicture(MultipartFile... file) {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (ValidatorUtil.isEmpty(authorizedUser)) {
            return CommonResponse.failed("用户信息获取失败!");
        }

        final List<UploadFile> uploadFiles = new ArrayList<>();
        try {
            for (int i = 0; i < file.length; i++) {
                final String fileName = file[i].getOriginalFilename();
                final Long fileKey = fileService.uploadFile(authorizedUser.getTenantId(), authorizedUser.getId(), fileName, file[i].getInputStream());
                if (ValidatorUtil.isEmpty(fileKey)) {
                    throw new ElephantException("上传至文件服务失败!");
                }
                final String url = fileService.getFileUrl(authorizedUser.getTenantId(), authorizedUser.getId(), fileKey);
                final UploadFile uploadFile = new UploadFile();
                uploadFile.setFileName(fileName);
                uploadFile.setFileUrl(url);
                uploadFiles.add(uploadFile);
            }
        } catch (Exception e) {
            return CommonResponse.failed("上传文件失败");
        }
        return CommonResponse.ok("上传成功", uploadFiles);
    }

}
