package com.xforceplus.elephant.image.controller.imagereturn.process;

import com.google.common.collect.Lists;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetImageReturnLogListRequest;
import com.xforceplus.elephant.image.client.model.ImageReturnDTO;
import com.xforceplus.elephant.image.core.domain.image.ImageReturnService;
import com.xforceplus.elephant.image.core.repository.model.ImageReturnEntity;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetImageReturnLogListProcess extends AbstractProcess<GetImageReturnLogListRequest, List<ImageReturnDTO>> {

    @Autowired
    private ImageReturnService imageReturnService;

    @Override
    protected void check(GetImageReturnLogListRequest request) throws ValidationException {
        super.check(request);
        /*if (ValidatorUtil.isEmpty(request.getImageId())) {
            throw new ValidationException("影像ID【imageId】不能为空");
        }*/
    }

    @Override
    protected CommonResponse<List<ImageReturnDTO>> process(GetImageReturnLogListRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        List<ImageReturnEntity> entityList = Lists.newArrayList();
        if (ValidatorUtil.isNotEmpty(request.getImageId())) {
            entityList = imageReturnService.selectImageBackByImageId(authorizedUser.getTenantId(), request.getImageId(), request.getOperateType());
        } else if (ValidatorUtil.isNotEmpty(request.getBillCode())) {
            entityList = imageReturnService.selectImageBackByBillCode(authorizedUser.getTenantId(), request.getBillCode(), request.getOperateType());
        }
        List<ImageReturnDTO> dtoList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(entityList)) {
            dtoList = entityList.stream().map(r -> {
                final ImageReturnDTO dto = new ImageReturnDTO();
                BeanUtils.copyProperties(r, dto);
                return dto;
            }).collect(Collectors.toList());
        }
        return CommonResponse.ok("成功", dtoList);
    }

}