package com.xforceplus.elephant.image.controller.scantodo.process;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.xforceplus.elephant.basecommon.enums.common.PageCodeEnum;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.facade.application.collect.bill.BillFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.metadata.domain.vo.dto.UltPageBoItem;
import java.util.List;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

@RequiredArgsConstructor
@Service
public class GetCountTodoInfoProcess extends AbstractProcess<BaseRequest, JSONObject> {

    private final BillFacade billFacade;

    @Override
    protected CommonResponse<JSONObject> process(BaseRequest request) throws RuntimeException {
        // 获取登录用户上下文
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        //统计待办
        final Integer[] total = {0};
        final List<JSONObject> entityList = Lists.newLinkedList();
        //查询扫描待办页，配置code
        final List<UltPageBoItem> boItemList = billFacade.getUltPageBoItemList(authorizedUser.getTenantId(), authorizedUser.getTenantCode(), PageCodeEnum.SCAN_TODO.getCode());
        if (ValidatorUtil.isNotEmpty(boItemList)) {
            boItemList.stream().forEach(r -> {
                final JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", ValidatorUtil.isNotEmpty(r.getRemark()) ? r.getRemark() : r.getBoName());
                //当前租户，扫描人，待提交，单据类型
                final Integer count = billFacade.countBillByParams(authorizedUser.getTenantId(), authorizedUser.getId(), r.getBoCode(), BillDataStatus._0.getCode());
                jsonObject.put("count", count);
                entityList.add(jsonObject);
                total[0] += count;
            });
        }
        final JSONObject result = new JSONObject();
        result.put("total", total[0]);
        result.put("list", entityList);
        return CommonResponse.ok("成功", result);
    }

}
