package com.xforceplus.elephant.image.controller.ticket.process.save;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.api.client.util.Lists;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.baseconst.ConfigConstants;
import com.xforceplus.elephant.basecommon.baseconst.Constants;
import com.xforceplus.elephant.basecommon.baseconst.ReleationConstants;
import com.xforceplus.elephant.basecommon.dispatch.BeanDispatcher;
import com.xforceplus.elephant.basecommon.enums.EntityConstant;
import com.xforceplus.elephant.basecommon.enums.bill.OperateEnum;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.SaveTicketDataRequest;
import com.xforceplus.elephant.image.core.business.application.calculate.check.engine.registry.ticket.TicketRepeatCheck;
import com.xforceplus.elephant.image.core.business.application.calculate.check.engine.registry.ticket.TicketUsedAmountCheck;
import com.xforceplus.elephant.image.core.business.application.calculate.relation.ticket.TicketRelationService;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.domain.TicketCheckContentConfig;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.domain.TicketCompareConfig;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.ChangeTrigger;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.business.enums.FileTypeEnum;
import com.xforceplus.elephant.image.core.business.enums.InvoiceTypeEnum;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.business.enums.ResourceEnum;
import com.xforceplus.elephant.image.core.business.util.LogUtil;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.common.TicketSupport;
import com.xforceplus.elephant.image.core.domain.config.ConfigDictionaryService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.domain.config.bean.ConfigDictionaryItem;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.imagefile.ImageFileService;
import com.xforceplus.elephant.image.core.domain.ticket.BillTicketRelationService;
import com.xforceplus.elephant.image.core.domain.ticket.BillTicketReuseService;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.expand.impl.billimageticket.DefaultBillImageTicketServiceImpl;
import com.xforceplus.elephant.image.core.facade.application.auth.DataResourceFacade;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketDetailFacade;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketFacade;
import com.xforceplus.elephant.image.core.facade.application.edit.TicketEditFacade;
import com.xforceplus.elephant.image.core.util.ImageOrgUtils;
import com.xforceplus.elephant.image.core.util.RequestBuilder;
import com.xforceplus.elephant.image.core.util.ValidateUtils;
import com.xforceplus.general.utils.GeneralUtil;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CheckSignStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CheckStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.InvoiceStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.InvoiceType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.TicketRelType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BillTicketRelation;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BillTicketReuse;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ImageFile;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.TicketRelation;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.ConfigSettings;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.TicketPlane;
import com.xforceplus.ultraman.metadata.domain.record.EmptyValue;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.xlog.core.model.LogContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import lombok.var;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Dispatch(isDefault = true)
@Service
public class DefaultSaveTicketDataProcess extends AbstractProcess<SaveTicketDataRequest, Boolean> {

    @Autowired
    protected TicketRelationService ticketRelationService;
    @Autowired
    private TicketService ticketService;
    @Autowired
    private BaseBillService baseBillService;
    @Autowired
    private ImageService imageService;
    @Autowired
    private ConfigDictionaryService configDictionaryService;
    @Autowired
    private BillImageTicketService billImageTicketService;
    @Autowired
    private MQUtils rabbitmqUtils;
    @Autowired
    private BillTicketRelationService billTicketRelationService;
    @Autowired
    private BillTicketReuseService billTicketReuseService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private BeanDispatcher beanDispatcher;
    @Autowired
    private DataResourceFacade dataResourceFacade;
    @Autowired
    private TicketEditFacade ticketEditFacade;
    @Autowired
    private ImageFileService imageFileService;
    @Autowired
    private ConfigSettingsService configSettingsService;
    @Autowired
    private ImageOrgUtils imageOrgUtils;
    @Autowired
    private TicketDetailFacade ticketDetailFacade;
    @Autowired
    private TicketFacade ticketFacade;
    @Autowired
    private TicketSupport ticketSupport;

    @Override
    protected void check(final SaveTicketDataRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getOperateType())) {
            throw new ValidationException("操作类型【operateType】不能为空");
        }
        if (!Constants.NUMBER_ZERO.equals(request.getOperateType()) && !Constants.NUMBER_ONE.equals(request.getOperateType())) {
            throw new ValidationException("操作类型【operateType】传参有误：1-新增,0-修改");
        }
        if (Constants.NUMBER_ZERO.equals(request.getOperateType())) {
            if (ValidatorUtil.isEmpty(request.getParTicketId())) {
                throw new ValidationException("父单证ID【parTicketId】不能为空");
            }
            if (ValidatorUtil.isEmpty(request.getSubTicketId())) {
                throw new ValidationException("子单证ID【subTicketId】不能为空");
            }
        }
        if (Constants.NUMBER_ONE.equals(request.getOperateType())) {
            if (ValidatorUtil.isEmpty(request.getImageId())) {
                throw new ValidationException("影像ID【imageId】不能为空");
            }
        }
        if (ValidatorUtil.isEmpty(request.getTicketCode())) {
            throw new ValidationException("单证code【ticketCode】不能为空");
        }
        ValidateUtils.checkArgument(request.getLabelIdList().size() > 5, "最多只能打5个标签");
    }

    protected void checkDataResource(final Long tenantId, final SaveTicketDataRequest request) {
        if (ValidatorUtil.isNotEmpty(request.getBillCode())) {
            final BaseBill billEntity = baseBillService.selectBaseBillByCode(tenantId, request.getBillCode());
            //JXCPX-5729 碧桂园#审单人可以用标签标记：敏感件(允许已锁定已完成数据标记系统标签)
            /*if (billEntity != null && Arrays.asList(BillDataStatus._3.getCode(), BillDataStatus._1.getCode()).contains(billEntity.getBillDataStatus())) {
                throw new ValidationException("单据已锁定/已完成状态不可修改单证");
            }*/
            if (!dataResourceFacade.existBillDetailResourceAuth(tenantId, request.getPageCode(), request.getScene(), billEntity, ResourceEnum.BILL_DETAILS_EDIT.getCode())) {
                throw new ValidationException("没有操作权限");
            }
        }
    }

    @Override
    protected CommonResponse<Boolean> process(final SaveTicketDataRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        //jira-1572 租户是否开启非增票权限校验
        final String checkNVatPermissionValue = configSettingsService
            .select(authorizedUser.getTenantId(), ConfigSettings.IS_CHECK_N_VAT_PERMISSION.code(), String.class, YesNo._0.getCode());
        final boolean checkPermission = YesNo._1.getCode().equals(checkNVatPermissionValue);
        int count = 0;
        Long preTicketId = request.getParTicketId();
        Long subTicketId = request.getSubTicketId();
        Long imageId = null;
        //没有修改单证类型
        boolean isUpdateType = false;
        //没有修改发票类型
        boolean isUpdateInvoiceType = false;
        String oldPurchaserTaxNo = StringUtils.EMPTY;
        String origTicketCode = StringUtils.EMPTY;
        String repeatTag = StringUtils.EMPTY;
        String reuseTag = StringUtils.EMPTY;
        String oldInvoiceType = StringUtils.EMPTY;
        final Map<String, Object> sourceTicketMap;

        final Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            JSONObject jsonObject = new JSONObject();
            if (!StringHelp.safeIsEmpty(request.getFormData())) {
                jsonObject = JSONObject.parseObject(request.getFormData());
            }
            jsonObject = setUserInfo(authorizedUser, request, jsonObject);
            final Image image = imageService.selectOne(authorizedUser.getTenantId(), jsonObject.getLong(EntityMeta.Ticket.IMAGE_ID.code()));
            if (null == image) {
                return CommonResponse.failed("影像数据不存在.");
            }
            final ImageFile imageFile = image.getFileId() != null && image.getFileId() > 0 ? imageFileService.selectOne(image.getFileId()) : null;
            if (Constants.NUMBER_ZERO.equals(request.getOperateType())) {
                //数据权限过滤
                checkDataResource(authorizedUser.getTenantId(), request);

                final Ticket ticket = ticketService.selectBaseTicketById(request.getParTicketId());
                if (null == ticket) {
                    return CommonResponse.failed("没有找到原单证数据.");
                }
                //JXCPX-3331 【中南集团】发票验真成功，发票购方名称被修改
                if (ValidatorUtil.isNotEmpty(jsonObject.getString(EntityMeta.Ticket.CHECK_STATUS.code()))
                    && !StringUtils.equals(ticket.getCheckStatus(), jsonObject.getString(EntityMeta.Ticket.CHECK_STATUS.code()))) {
                    return CommonResponse.failed("验真状态已更新，请重试.");
                }
                final String isMultipurposeTicket = configSettingsService.select(authorizedUser.getTenantId(),
                    EntityMeta.ConfigSettings.IS_MULTIPURPOSE_TICKET.code(), String.class, YesNo._0.getCode());
                //if (YesNo._1.getCode().equals(isMultipurposeTicket) && EntityMeta.TicketInvoice.code().equals(ticket.getTicketCode()) {
                if (false) {
                    //校验金额
                    if (ValidatorUtil.isNotEmpty(request.getUsedAmount()) && request.getUsedAmount()
                                                                                    .compareTo(ticket.getUsedAmount().add(ticket.getBalanceAmount())) == 1) {
                        return CommonResponse.failed("您修改的个人可提报金额大于可提报金额，无法保存.");
                    }
                    final List<String> exceptionKeys =
                        ValidatorUtil.isNotEmpty(ticket.getExceptionKey()) ? Arrays.asList(StringHelp.safeToString(ticket.getExceptionKey()).split(",")) : new ArrayList<>();
                    if (exceptionKeys.contains(TicketRepeatCheck.CHECK_CODE)
                        && ValidatorUtil.isNotEmpty(request.getUsedAmount()) && request.getUsedAmount().compareTo(ticket.getUsedAmount()) != 0) {
                        return CommonResponse.failed("发票重复,请删除当前采集发票");
                    }
                    if (!exceptionKeys.contains(TicketUsedAmountCheck.CHECK_CODE) && exceptionKeys.size() > 0
                        && ValidatorUtil.isNotEmpty(request.getUsedAmount()) && request.getUsedAmount().compareTo(ticket.getUsedAmount()) != 0) {
                        return CommonResponse.failed("发票异常,请处理好异常后再修改提报金额");
                    }
                    //修改金额 计算余额
                    if (ValidatorUtil.isNotEmpty(request.getUsedAmount()) && request.getUsedAmount().compareTo(ticket.getUsedAmount()) != 0) {
                        LogUtil.attachLogPoint("isUsedAmountChanged", true);
                        final BigDecimal balanceAmount = ticket.getUsedAmount().add(ticket.getBalanceAmount()).subtract(request.getUsedAmount());
                        final List<Map<String, Object>> repeatTicketMap = ticketService.selectTicketByRepeatTag(authorizedUser.getTenantId(), ticket.getRepeatTag(), EntityMeta.Ticket.code());
                        if (ValidatorUtil.isNotEmpty(repeatTicketMap)) {
                            final List<Long> ticketIds = repeatTicketMap.stream()
                                                                        .filter(map -> !map.get(EntityMeta.Ticket.ID.code()).toString().equals(ticket.getId().toString()))
                                                                        .map(map -> Long.valueOf(map.get("id").toString())).collect(Collectors.toList());
                            final JSONObject update = new JSONObject();
                            update.put(EntityMeta.Ticket.USED_AMOUNT.code(), request.getUsedAmount());
                            update.put(EntityMeta.Ticket.BALANCE_AMOUNT.code(), balanceAmount);
                            ticketService.updateTicketByParam(ticket.getId(), EntityMeta.Ticket.code(), update);
                            update.remove(EntityMeta.Ticket.USED_AMOUNT.code());
                            ticketIds.forEach(id -> ticketService.updateTicketByParam(id, EntityMeta.Ticket.code(), update));
                        } else {
                            final JSONObject update = new JSONObject();
                            update.put(EntityMeta.Ticket.USED_AMOUNT.code(), request.getUsedAmount());
                            update.put(EntityMeta.Ticket.BALANCE_AMOUNT.code(), balanceAmount);
                            ticketService.updateTicketByParam(ticket.getId(), EntityMeta.Ticket.code(), update);
                        }
                        //一票多用模式转换，不需要再复制
                        //billImageTicketService.createEmptyBillCodeTicket(ticket.getTenantId(), ticket.getImageId());

                    }
                }
                final String checkSaveCmdBeforeMessage = checkSaveCmdBefore(ticket);
                if (ValidatorUtil.isNotEmpty(checkSaveCmdBeforeMessage)) {
                    return CommonResponse.failed(checkSaveCmdBeforeMessage);
                }
                sourceTicketMap = ticketService.selectByTicketCode(ticket.getTicketCode(), subTicketId);
                if (ValidatorUtil.isNotEmpty(sourceTicketMap)) {
                    oldInvoiceType = String.valueOf(sourceTicketMap.get(EntityMeta.Ticket.INVOICE_TYPE.code()));
                    oldPurchaserTaxNo = GeneralUtil.asString(sourceTicketMap.get(EntityMeta.Ticket.PURCHASER_NO.code()));
                }
                final var reqFormData = JSONObject.parseObject(request.getFormData());
                final String reqInvoiceType = reqFormData.getString(EntityMeta.Ticket.INVOICE_TYPE.code());
                final String reqPurchaserTaxNo = reqFormData.getString(EntityMeta.Ticket.PURCHASER_TAX_NO.code());
                final String ticketCode = reqFormData.getString(EntityMeta.Ticket.TICKET_CODE.code());

                //发票类型+发票代码+发票号码 发生变更计算重复， 复制票不包含在内
                final List<String> repeatMsgList = Lists.newArrayList();
                ticketSupport.checkRepeatBeforeSave(authorizedUser.getTenantId(), sourceTicketMap, jsonObject, repeatInvoices -> {
                    final Optional<Map<String, Object>> repeatSelfOptional = repeatInvoices.stream()
                                                                                           .filter(p -> MapUtils.getLong(p, EntityMeta.Ticket.SCAN_USER_ID.code()).equals(authorizedUser.getId()))
                                                                                           .findAny();
                    final Optional<Map<String, Object>> repeatOtherOptional = repeatInvoices.stream()
                                                                                            .filter(p -> !MapUtils.getLong(p, EntityMeta.Ticket.SCAN_USER_ID.code()).equals(authorizedUser.getId()))
                                                                                            .findAny();
                    repeatSelfOptional.ifPresent(map -> repeatMsgList.add(String.format("发票重复,已经在单据:%s下使用过该发票", MapUtils.getString(map, EntityMeta.Ticket.BILL_CODE.code()))));
                    if (repeatOtherOptional.isPresent()) {
                        repeatMsgList.add("发票和他人重复,不可使用该张发票");
                    }
                });
                if (!CollectionUtils.isEmpty(repeatMsgList)) {
                    return CommonResponse.failed(Joiner.on(";").join(repeatMsgList));
                }

                if (checkPermission && !EntityMeta.TicketInvoice.code().equals(ticketCode)) {
                    final boolean isUpdatePurchaserTaxNo = StringUtils.isNotBlank(reqPurchaserTaxNo) && !StringUtils.equals(reqPurchaserTaxNo, oldPurchaserTaxNo);
                    if (isUpdatePurchaserTaxNo) {
                        final JSONArray orgList = imageOrgUtils.getOrgList(authorizedUser.getTenantId(), reqPurchaserTaxNo);
                        if (orgList.size() == 0) {
                            return CommonResponse.failed("税号:" + reqPurchaserTaxNo + "不存在");
                        }
                        final JSONObject org = (JSONObject) orgList.get(0);
                        jsonObject.put(EntityMeta.Ticket.ORG_ID.code(), org.getLongValue("orgId"));
                        jsonObject.put(EntityMeta.Ticket.ORG_CODE.code(), org.getString("orgCode"));
                        jsonObject.put(EntityMeta.Ticket.ORG_NAME.code(), org.getString("orgName"));
                        jsonObject.put(EntityMeta.Ticket.PURCHASER_TAX_NO.code(), org.getString("taxNum"));
                        jsonObject.put(EntityMeta.Ticket.PURCHASER_NAME.code(), org.getString("companyName"));
                    }
                }
                //如果修改了invoice_type 则需要重置验真状态
                if (!oldInvoiceType.equals(reqInvoiceType)) {
                    isUpdateInvoiceType = true;
                }
                if (YesNo._0.getCode().equals(ticket.getIsPublic())) {
                    final JSONObject checkJson = new JSONObject();
                    checkJson.putAll(new JSONObject(ticket.toOQSMap()));
                    if (!StringHelp.safeIsEmpty(reqFormData)) {
                        checkJson.putAll(reqFormData);
                    }
                    final String repeatInfo = billImageTicketService.checkTicketRepeat(ticket.getTicketCode(), ticket, checkJson, authorizedUser.getTenantId());
                    if (ValidatorUtil.isNotEmpty(repeatInfo)) {
                        return CommonResponse.failed(repeatInfo);
                    }
                }

                //校验影像是否多票，多票有结构数据不允许修改
                if (checkManyUpdate(ticket, request.getTicketCode())) {
                    return CommonResponse.failed("多票包含其他影像数据，不允许修改类型.");
                }
                if (!request.getTicketCode().equals(ticket.getTicketCode())) {
                    isUpdateType = true;//修改了单证
                    origTicketCode = ticket.getTicketCode();
                    if (!EntityMeta.TicketAttachment.code().equals(request.getTicketCode())) {
                        jsonObject.put(ReleationConstants.TICKET_OTM_TICKET_ID, 0L);
                    }
                }
                jsonObject.remove("check_status");
                //判断验真状态是否重置
                checkVerifyStatus(jsonObject, request.getTicketCode(), authorizedUser.getTenantId(), subTicketId, ticket.getCheckStatus(), isUpdateType, isUpdateInvoiceType);
                //判断验签状态是否重置
                checkSignStatus(jsonObject, image, authorizedUser.getTenantId());
                //检测源文件
                processTicketSourceFile(imageFile, jsonObject);
                //JXCPX-1320 判断是否更新组织id
                checkOrgId(authorizedUser.getTenantId(), ticket.getPurchaserTaxNo(), jsonObject);
                //没有修改单证类型
                if (!isUpdateType) {
                    boolean isRepeatFlag = false;
                    try {
                        isRepeatFlag = checkRepeatTicket(authorizedUser.getTenantId(), reqFormData, ticket, subTicketId);
                    } catch (final Exception e) {
                        logger.info("编辑后计算关系异常", e);
                    }
                    handleTicketModifyFlag(authorizedUser.getTenantId(), sourceTicketMap, jsonObject);
                    jsonObject.remove(EntityMeta.Ticket.IS_REPEAT.code());
                    jsonObject.remove(EntityMeta.Ticket.REPEAT_TAG.code());
                    jsonObject.remove("is_exception");
                    jsonObject.remove(EntityMeta.Ticket.EXCEPTION_STATUS.code());
                    jsonObject.remove(EntityMeta.Ticket.WARNING_INFO.code());
                    jsonObject.remove(EntityMeta.Ticket.EXCEPTION_INFO.code());
                    jsonObject.remove(EntityMeta.Ticket.IS_EXIST_SHEET.code());
                    jsonObject.remove(EntityMeta.Ticket.CHECK_TASK_ID.code());
                    jsonObject.remove(EntityMeta.Ticket.USED_AMOUNT.code());
                    jsonObject.remove(EntityMeta.Ticket.BALANCE_AMOUNT.code());
                    if (isRepeatFlag && YesNo._1.getCode().equals(isMultipurposeTicket) && EntityMeta.TicketInvoice.code().equals(ticket.getTicketCode())) {
                        final ConditionQueryRequest conditionQueryRequest = new RequestBuilder()
                            .field(EntityMeta.Ticket.TENANT_ID.code(), ConditionOp.eq, authorizedUser.getTenantId())
                            .field(EntityMeta.Ticket.INVOICE_NO.code(), ConditionOp.eq, jsonObject.getString(EntityMeta.Ticket.INVOICE_NO.code()))
                            .field(EntityMeta.Ticket.INVOICE_CODE.code(), ConditionOp.eq, jsonObject.getString(EntityMeta.Ticket.INVOICE_CODE.code()))
                            .build();
                        final List<Map<String, Object>> mapList = ticketService.selectByCondition(EntityMeta.Ticket.code(), conditionQueryRequest);
                        if (ValidatorUtil.isNotEmpty(mapList)) {
                            jsonObject.put(EntityMeta.Ticket.USED_AMOUNT.code(), 0);
                            jsonObject.put(EntityMeta.Ticket.BALANCE_AMOUNT.code(), mapList.get(0).get(EntityMeta.Ticket.BALANCE_AMOUNT.code()));
                        } else {
                            //有单无重复，单据占满，余额为0，无单无重复，占用为0，余额等于金额
                            if (ValidatorUtil.isNotEmpty(ticket.getBillCode())) {
                                jsonObject.put(EntityMeta.Ticket.USED_AMOUNT.code(), jsonObject.get(EntityMeta.Ticket.AMOUNT_WITH_TAX.code()));
                                jsonObject.put(EntityMeta.Ticket.BALANCE_AMOUNT.code(), 0);
                            } else {
                                jsonObject.put(EntityMeta.Ticket.USED_AMOUNT.code(), 0);
                                jsonObject.put(EntityMeta.Ticket.BALANCE_AMOUNT.code(), jsonObject.get(EntityMeta.Ticket.AMOUNT_WITH_TAX.code()));
                            }
                        }
                    }
                    //JXCPX-7984【影像移动端】我的票夹&单据采集&单证稽核-编辑-修改&清除不含税金额、税额、含税金额保存，出现不友好提示
                    checkUpdateAmount(jsonObject);
                    count = ticketService.updateTicketByParam(request.getSubTicketId(), ticket.getTicketCode(), jsonObject);
                } else {
                    //删除原单证类型
                    final int num = ticketService.deleteTicketByCode(EntityConstant.TICKET, request.getParTicketId());
                    if (num == 0) {
                        return CommonResponse.failed("原单证删除失败，请重新操作.");
                    }
                    final Long createTime = jsonObject.getLong("create_time");
                    //删除重复关系
                    clearRepeatReuse(jsonObject, request.getSubTicketId(), ticket.getTicketCode());
                    resetTicketAddAndChangeFlag(jsonObject);
                    jsonObject.remove("id");
                    jsonObject.remove(EntityMeta.Ticket.COMPUTED_STATE.code());
                    if (false) {
                        final ConditionQueryRequest conditionQueryRequest = new RequestBuilder()
                            .field(EntityMeta.Ticket.TENANT_ID.code(), ConditionOp.eq, authorizedUser.getTenantId())
                            .field(EntityMeta.Ticket.INVOICE_NO.code(), ConditionOp.eq, ticket.getInvoiceNo())
                            .field(EntityMeta.Ticket.INVOICE_CODE.code(), ConditionOp.eq, ticket.getInvoiceCode())
                            .build();
                        final List<Map<String, Object>> mapList = ticketService.selectByCondition(EntityMeta.Ticket.code(), conditionQueryRequest);
                        if (ValidatorUtil.isNotEmpty(mapList)) {
                            final JSONObject update = new JSONObject();
                            if (mapList.size() == 1) {
                                update.put(EntityMeta.Ticket.BALANCE_AMOUNT.code(), ticket.getAmountWithTax());
                            } else {
                                //历史租户开通一票多用，防null处理
                                final BigDecimal usedAmount = ticket.getUsedAmount() != null ? ticket.getUsedAmount() : BigDecimal.ZERO;
                                final BigDecimal balanceAmount = ticket.getBalanceAmount() != null ? ticket.getBalanceAmount() : ticket.getAmountWithTax();
                                final BigDecimal newBalanceAmount = usedAmount.add(balanceAmount);
                                jsonObject.put(EntityMeta.Ticket.USED_AMOUNT.code(), 0);
                                jsonObject.put(EntityMeta.Ticket.BALANCE_AMOUNT.code(), newBalanceAmount);
                                update.put(EntityMeta.Ticket.BALANCE_AMOUNT.code(), newBalanceAmount);
                                ticketService.updateTicketByParam(ticket.getId(), EntityMeta.Ticket.code(), update);
                            }
                            mapList.forEach(t -> ticketService.updateTicketByParam(Long.valueOf(StringHelp.safeToString(t.get(EntityMeta.Ticket.ID.code()))),
                                EntityMeta.Ticket.code(), update));
                        } else {
                            //有单无重复，单据占满，余额为0，无单无重复，占用为0，余额等于金额
                            if (ValidatorUtil.isNotEmpty(ticket.getBillCode())) {
                                jsonObject.put(EntityMeta.Ticket.USED_AMOUNT.code(), jsonObject.get(EntityMeta.Ticket.AMOUNT_WITH_TAX.code()));
                                jsonObject.put(EntityMeta.Ticket.BALANCE_AMOUNT.code(), 0);
                            } else {
                                jsonObject.put(EntityMeta.Ticket.USED_AMOUNT.code(), 0);
                                jsonObject.put(EntityMeta.Ticket.BALANCE_AMOUNT.code(), jsonObject.get(EntityMeta.Ticket.AMOUNT_WITH_TAX.code()));
                            }
                        }
                    }
                    //JXCPX-7984【影像移动端】我的票夹&单据采集&单证稽核-编辑-修改&清除不含税金额、税额、含税金额保存，出现不友好提示
                    checkCreateAmount(jsonObject);
                    final Long id = ticketService.insertInheritTicketByCode(request.getTicketCode(), jsonObject);
                    if (null == id) {
                        return CommonResponse.failed("单证保存失败，请检查.");
                    }
                    preTicketId = id;
                    subTicketId = id;
                    count = id > 0L ? 1 : 0;
                    if (count > 0) {
                        final Map<String, Object> updateMap = Maps.newHashMap();
                        updateMap.put("create_time", createTime);
                        updateMap.put("scan_time", createTime);
                        ticketService.updateTicketByParam(preTicketId, EntityConstant.TICKET, updateMap);
                    }
                }
                imageId = ticket.getImageId();
                //JXCPX-2827 自定义字段遗留问题-后端研发子任务
                final Map<String, Object> extValue = jsonObject.entrySet().stream()
                                                               .filter(entry -> entry.getKey().startsWith("ext") && entry.getValue() != null)
                                                               .collect(Collectors.toMap(entry -> entry.getKey(), entry -> entry.getValue()));
                if (ValidatorUtil.isNotEmpty(extValue)) {
                    imageService.updateByParam(imageId, new JSONObject(extValue));
                }
                repeatTag = ticket.getRepeatTag();
                reuseTag = ticket.getReuseTag();
                //计算连号
                checkTicketConsecutiveNumber(authorizedUser.getTenantId(), jsonObject.getString(EntityMeta.Ticket.INVOICE_NO.code()), ticket, isUpdateType);
                if (EntityMeta.TicketAttachment.code().equals(request.getTicketCode())) {
                    billImageTicketService.clearTicketAttachmentRelation(authorizedUser.getTenantId(), ticket.getImageId(), ticket.getId());
                }
            }
            stopwatch.stop();
            LogContext.setLogPoint("updateData", stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.reset().start();
            //新增
            if (Constants.NUMBER_ONE.equals(request.getOperateType())) {
                jsonObject.put("is_public", image.getIsPublic());
                jsonObject.put("batch_no", image.getBatchNo());
                if (null != request.getBillCode()) {
                    final BaseBill billEntity = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(), request.getBillCode());
                    if (null == billEntity) {
                        return CommonResponse.failed("新增单据数据不存在，无法挂接.");
                    }
                    jsonObject.put("bill_code", billEntity.getBillCode());
                    jsonObject.put("is_hooked", YesNo._1.getCode());
                    jsonObject.put(EntityMeta.Ticket.HOOK_TIME.code(), System.currentTimeMillis());
                    jsonObject.put(EntityMeta.Ticket.BILL_SYSTEM_SOURCE.code(), billEntity.getSystemOrig());
                    jsonObject.put(EntityMeta.Ticket.BILL_O_T_M_TICKET_ID.code(), billEntity.getId());
                    handleManyTicketAddFlag(billEntity, jsonObject);
                }
                //判断验真状态
                checkVerifyStatus(jsonObject, request.getTicketCode(), authorizedUser.getTenantId(), null, null, true, isUpdateInvoiceType);
                jsonObject.remove("id");
                //JXCPX-7984【影像移动端】我的票夹&单据采集&单证稽核-编辑-修改&清除不含税金额、税额、含税金额保存，出现不友好提示
                checkCreateAmount(jsonObject);
                final Long id = ticketService.insertInheritTicketByCode(request.getTicketCode(), jsonObject);
                if (null == id) {
                    return CommonResponse.failed("单证保存失败，请检查.");
                }
                billImageTicketService.checkTicketRepeatAndReuse(authorizedUser.getTenantId(), Collections.singletonList(jsonObject.getLong("image_id")), OperateEnum.DELETE,
                    jsonObject.getString("bill_code"));
                preTicketId = id;
                subTicketId = id;
                count = id > 0L ? 1 : 0;
                imageId = request.getImageId();
            }
            stopwatch.stop();
            LogContext.setLogPoint("createData", stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.reset().start();
            // 保存标签到历史记录
            ticketDetailFacade.saveSystemLabelHistory(authorizedUser.getId(), request.getLabelIdList());
            if (checkPermission) {
                final String billCode = image.getBillCode();
                if (ValidatorUtil.isNotEmpty(billCode)) {
                    billImageTicketService.resetLevel(authorizedUser.getTenantId(), billCode);
                } else {
                    final String batchNo = image.getBatchNo();
                    if (ValidatorUtil.isNotEmpty(batchNo)) {
                        billImageTicketService.resetLevel(batchNo, authorizedUser.getId());
                    }
                }
            }
            stopwatch.stop();
            LogContext.setLogPoint("resetLevel", stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.reset().start();
        } catch (final Exception e) {
            logger.error("保存异常", e);
            return CommonResponse.failed("保存异常：" + e.getMessage());
        }
        if (count > 0) {
            //发起验签
            final Map<String, Object> entityMap = ticketService.selectByTicketCode(request.getTicketCode(), subTicketId);
            ticketFacade.pdfVerify(entityMap);

            //是否自动发验真
            isSendVerify(subTicketId, request.getTicketCode(), authorizedUser);
            //校验影像类型，改字
            updateCheckBillImage(authorizedUser.getTenantId(), request.getBillCode(), imageId, request.getTicketCode(), origTicketCode, isUpdateType, preTicketId);
            checkOtherTicket(repeatTag, reuseTag);

            if (imageId != null) {
                billImageTicketService.updateManyExceWarnData(imageId);
                //修改影像
                billImageTicketService.updateImageExceWarnData(authorizedUser.getTenantId(), imageId);
            }
            billImageTicketService.updateRecogBillInfo(authorizedUser.getTenantId(), request.getBillCode());
            if (StringHelp.safeIsEmpty(request.getBillCode())) {
                //发送mq,校验单证异常预警信息
                final Map<String, Object> paramMap = Maps.newHashMap();
                paramMap.put("ticketId", subTicketId);
                paramMap.put("ticketCode", request.getTicketCode());
                paramMap.put("source", "编辑单证保存后重算单证");
                final Map<String, Object> headers = new HashMap<>();
                headers.put(TENANT_CODE, authorizedUser.getTenantCode());
                rabbitmqUtils.sendByDirectExchange(MQEnum.CHECK_TICKET_EXCE_WARN_QUEUE, paramMap, headers);
            } else {
                final BaseBill billEntity = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(), request.getBillCode());
                if (!Objects.isNull(billEntity) && BillDataStatus.fromCode(billEntity.getBillDataStatus()) == BillDataStatus._6) {
                    //单据修改保存,修改单据状态
                    final JSONObject updater = new JSONObject();
                    updater.put(EntityMeta.BaseBill.BILL_DATA_STATUS.code(), BillDataStatus._0.getCode());
                    baseBillService.updateByBillIdSelective(billEntity.getId(), updater);
                }
            }
            stopwatch.stop();
            LogContext.setLogPoint("afterSaveData", stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return CommonResponse.ok("保存成功", true);
        } else {
            return CommonResponse.failed("无记录保存成功");
        }
    }

    /**
     * 修改的是多票，有其他数据结构不让修改
     *
     * @param entity 对象
     */
    private boolean checkManyUpdate(final Ticket entity, final String updateTicketCode) {
        if (EntityConstant.TICKET_MANY.equals(entity.getTicketCode()) && !EntityConstant.TICKET_MANY.equals(updateTicketCode)) {
            final List<Ticket> entityList = ticketService.selectBaseTicketByImageID(entity.getImageId());
            return !CollectionUtils.isEmpty(entityList) && entityList.size() > 1;
        }
        return false;
    }

    /**
     * 设置用户信息
     *
     * @param authorizedUser 用户
     * @param request        请求
     * @param jsonObject     json对象
     */
    private JSONObject setUserInfo(final IAuthorizedUser authorizedUser, final SaveTicketDataRequest request, final JSONObject jsonObject) {
        jsonObject.put("ticket_code", request.getTicketCode());
        if (Constants.NUMBER_ZERO.equals(request.getOperateType())) {
            jsonObject.put("update_time", System.currentTimeMillis());
            jsonObject.put("update_user_id", authorizedUser.getId());
            jsonObject.put("update_user_name", authorizedUser.getUsername());
        } else {
            final long ccurrentTime = System.currentTimeMillis();
            jsonObject.put("create_time", ccurrentTime);
            jsonObject.put("create_user_id", authorizedUser.getId());
            jsonObject.put("create_user_name", authorizedUser.getUsername());
            jsonObject.put("scan_user_id", authorizedUser.getId());
            jsonObject.put("scan_user_name", authorizedUser.getUsername());
            jsonObject.put("scan_time", ccurrentTime);
            jsonObject.put("tenant_id", authorizedUser.getTenantId());
            jsonObject.put("image_id", request.getImageId());
            if (null != request.getXPoint()) {
                jsonObject.put("x_point", request.getXPoint());
            }
            if (null != request.getYPoint()) {
                jsonObject.put("y_point", request.getYPoint());
            }
            if (null != request.getWidth()) {
                jsonObject.put("width", request.getWidth());
            }
            if (null != request.getHeight()) {
                jsonObject.put("height", request.getHeight());
            }
        }
        if (ValidatorUtil.isNotEmpty(request.getLabelIdList())) {
            jsonObject.put(ReleationConstants.SYSTEM_LABEL_ID, request.getLabelIdList().stream().map(Object::toString).collect(Collectors.joining(",")));
        } else {
            jsonObject.put(ReleationConstants.SYSTEM_LABEL_ID, StringUtils.EMPTY);
        }
        //获取公司编号
        getCompanyNo(authorizedUser.getTenantId(), request.getTicketCode(), jsonObject);
        //设置发票类型值
        //handleInvoiceType(request, jsonObject);
        //附件移除发票7要素
        removeField(request.getTicketCode(), jsonObject);
        //飞机票设置含税金额
        amountWithTax(request.getTicketCode(), jsonObject);
        //全电发票 发票代码设置为"全电发票"
        final String invoiceType = jsonObject.getString(EntityMeta.Ticket.INVOICE_TYPE.code());
        if (Arrays.asList(InvoiceType.QC.getCode(), InvoiceType.QS.getCode(), InvoiceType.QV.getCode()).contains(invoiceType)) {
            jsonObject.put(EntityMeta.Ticket.INVOICE_CODE.code(), com.xforceplus.elephant.image.core.business.consts.Constants.ALL_ELECTRIC_INVOICE_CODE);
        }
        //保存特殊发票标记
        if (ValidatorUtil.isNotEmpty(request.getSpecialInvoiceFlag())) {
            jsonObject.put(EntityMeta.Ticket.SPECIAL_INVOICE_FLAG.code(), request.getSpecialInvoiceFlag());
        }
        return jsonObject;
    }

    /**
     * 单据已退回，修改影像，添加改字标记
     *
     * @param billCode 业务单号
     * @param imageId  影像ID
     */
    private void updateCheckBillImage(final Long tenantId, final String billCode, final Long imageId, final String ticketCode, final String origTicketCode, final boolean isUpdateType,
        final Long preTicketId) {
        if (null == imageId) {
            return;
        }
        final JSONObject update = new JSONObject();
        //修改结构数据类型，影像类型同步修改
        final boolean isLevel = ticketSupport.updateImageTypeWhenAttach(update, isUpdateType, ticketCode, origTicketCode);
        //JXCPX-213 【saas】识别优化——识别超时置为附件并异常 手动编辑后默认影像识别完成
        update.put(EntityMeta.Image.REC_STATUS.code(), RecStatus._2.getCode());
        //影像退字标记去掉
        checkImageModify(tenantId, imageId, update);
        if (update.size() > 0) {
            update.put("id", imageId);
            final boolean success = imageService.updateImageSelective(JSONObject.parseObject(update.toString(), Image.class));
            if (success && isLevel && !StringHelp.safeIsEmpty(billCode)) {
                //重算层级
                billImageTicketService.resetLevel(tenantId, billCode);
            } else {
                //校验重复复用
                billImageTicketService.checkTicketRepeatAndReuse(tenantId, preTicketId, OperateEnum.HOOK, billCode);
            }
            return;
        }

        //校验重复复用
        billImageTicketService.checkTicketRepeatAndReuse(tenantId, preTicketId, OperateEnum.HOOK, billCode);

    }

    /**
     * 影像退字标记去掉
     *
     * @param tenantId 租户ID
     * @param imageId  影像ID
     * @param update   update
     * @return void
     * @author rongying
     * @date 2021/7/29 18:42
     */
    public void checkImageModify(final Long tenantId, final Long imageId, final JSONObject update) {
        final Image image = imageService.selectOne(tenantId, imageId);
        if (ValidatorUtil.isEmpty(image)) {
            return;
        }
        if (ValidatorUtil.isNotEmpty(image.getReturnStatus()) && !BackType._0.getCode().equals(image.getReturnStatus())) {
            update.put(EntityMeta.Image.RETURN_STATUS.code(), BackType._0.getCode());
            update.put(EntityMeta.Image.RETURN_REASON.code(), 0);
            update.put(EntityMeta.Image.RETURN_TYPE.code(), 0);
            update.put(EntityMeta.Image.RETURN_REMARK.code(), StringUtils.EMPTY);
        }
    }

    /**
     * 检查验真状态
     *
     * @param orgEntity  orgEntity
     * @param ticketCode 单证代码
     * @param tenantId   租户ID
     * @param ticketId   单证ID
     */
    private void checkVerifyStatus(final JSONObject orgEntity, final String ticketCode, final Long tenantId, final Long ticketId, final String checkStatus, final boolean isUpdateType,
        final boolean isUpdateInvoiceType) {
        //字典

        final List<ConfigDictionaryItem> dictionaryItemList = configDictionaryService.selectItems(tenantId, ConfigConstants.CONFIG_DICT_CODE_TICKET_CHEKCT_CONTENT);
        final Map<String, ConfigDictionaryItem> dictionaryMap =
            !CollectionUtils.isEmpty(dictionaryItemList) ? dictionaryItemList.stream().collect(Collectors.toMap(ConfigDictionaryItem::getItemCode, a -> a, (k1, k2) -> k1)) : Maps.newHashMap();
        final String newTicketCode = orgEntity.getString(EntityMeta.Ticket.INVOICE_TYPE.code());
        final ConfigDictionaryItem dictionaryItem = dictionaryMap.get(newTicketCode);
        if (null == dictionaryItem) {
            setVerifyField(orgEntity, CheckStatus._4.getCode(), "当前单证类型不支持验真.");
            return;
        }
        //没有修改类型
        if (!isUpdateType && !isUpdateInvoiceType) {
            //原验真状态是无需验真，直接返回
            if (ValidatorUtil.isNotEmpty(checkStatus) && CheckStatus._4.getCode().equals(checkStatus)) {
                return;
            }
            final JSONArray jsonArray = JSONArray.parseArray(dictionaryItem.getVerifyFields());
            if (null == jsonArray || jsonArray.size() < 0) {
                return;
            }
            //校验验真要素字段你是否修改
            final Map<String, Object> entityMap = ticketService.selectByTicketCode(ticketCode, ticketId);
            if (null == entityMap) {
                return;
            }
            int count = 0;
            for (int i = 0; i < jsonArray.size(); i++) {
                final JSONObject object = jsonArray.getJSONObject(i);
                final String field = object.getString("orgField");
                if (ValidatorUtil.isNotEmpty(orgEntity.getString(field)) && !orgEntity.getString(field).equals(entityMap.get(field))) {
                    count++;
                } else if (ValidatorUtil.isNotEmpty(entityMap.get(field)) && !entityMap.get(field).toString().equals(orgEntity.getString(field))) {
                    count++;
                }
            }
            if (count == 0) {
                return;
            }
            setVerifyField(orgEntity, CheckStatus._0.getCode(), StringUtils.EMPTY);
            return;
        }
        //类型变更：校验是否开启验真
        if (!dictionaryItem.isCheckVerify()) {
            setVerifyField(orgEntity, CheckStatus._4.getCode(), "当前单证类型不支持验真.");
            return;
        }
        //获取验真表达式（小开关）是否需要验真
        if (ValidatorUtil.isNotEmpty(dictionaryItem.getVerifyExpression())) {
            final ExpressionParser parser = new SpelExpressionParser();
            final EvaluationContext context = new StandardEvaluationContext();
            context.setVariable("obj", orgEntity);
            context.setVariable("details", getInvoiceDetailList(ticketId, ticketCode));
            final boolean verifyExpression = parser.parseExpression(dictionaryItem.getVerifyExpression()).getValue(context, Boolean.class);
            if (!verifyExpression) {
                setVerifyField(orgEntity, CheckStatus._4.getCode(), "当前单证类型不支持验真.");
                return;
            }
        }
        final JSONArray jsonArray = JSONArray.parseArray(dictionaryItem.getVerifyFields());
        if (null == jsonArray || jsonArray.size() < 0) {
            setVerifyField(orgEntity, CheckStatus._4.getCode(), "当前单证类型不支持验真.");
            return;
        }
        //类型变更后且有可验真字段，则重置验真状态，由客户发起重新验真
        setVerifyField(orgEntity, CheckStatus._0.getCode(), StringUtils.EMPTY);
    }

    /**
     * 重置验真状态
     *
     * @param orgEntity   orgEntity
     * @param checkStatus checkStatus
     * @param remark      remark
     */
    private void setVerifyField(final JSONObject orgEntity, final String checkStatus, final String remark) {
        orgEntity.put("check_status", checkStatus);
        orgEntity.put("check_remark", remark);
        orgEntity.put("check_task_id", StringUtils.EMPTY);
        orgEntity.put("check_user_id", 0L);
        orgEntity.put("check_user_name", StringUtils.EMPTY);
    }

    /**
     * 查询明细
     *
     * @param ticketId   单证id
     * @param ticketCode 单证code
     * @return java.util.List
     * @author rongying
     * @date 2022/3/30 15:29
     */
    protected List<JSONObject> getInvoiceDetailList(final Long ticketId, final String ticketCode) {
        if (!EntityMeta.TicketPlane.code().equals(ticketCode)) {
            return new ArrayList<>();
        }
        return ticketDetailFacade.selectTicketDetail(ticketId, ticketCode)
                                 .stream().map(item -> new JSONObject(item)).collect(Collectors.toList());
    }

    /**
     * 检查验真状态
     *
     * @param orgEntity orgEntity
     * @param tenantId  租户ID
     */
    private void checkSignStatus(final JSONObject orgEntity, final Image image, final Long tenantId) {
        //查询数据字典
        final List<TicketCheckContentConfig> checkContentList = configService.selectDict(tenantId, ConfigConstants.CONFIG_DICT_CODE_TICKET_CHEKCT_CONTENT, TicketCheckContentConfig.class);
        if (ValidatorUtil.isEmpty(checkContentList)) {
            setVerifySignField(orgEntity, CheckSignStatus._3.getCode());
            return;
        }
        final Map<String, TicketCheckContentConfig> checkContentMap = checkContentList.stream().collect(Collectors.toMap(TicketCheckContentConfig::getItemCode, a -> a, (k1, k2) -> k1));
        if (ValidatorUtil.isEmpty(checkContentMap)) {
            setVerifySignField(orgEntity, CheckSignStatus._3.getCode());
            return;
        }
        final String invoiceType = orgEntity.getString(EntityMeta.Ticket.INVOICE_TYPE.code());
        //未开启验签=无需验签
        final TicketCheckContentConfig checkContentItem = checkContentMap.get(invoiceType);
        if (checkContentItem == null || !checkContentItem.isCheckSign()) {
            setVerifySignField(orgEntity, CheckSignStatus._3.getCode());
            return;
        }
        //非pdf文件无需验签
        if (image == null || !FileTypeEnum.PDF.getCode().equalsIgnoreCase(image.getFileType())) {
            setVerifySignField(orgEntity, CheckSignStatus._3.getCode());
            return;
        }
        final String checkSignStatus = orgEntity.getString(EntityMeta.Ticket.CHECK_SIGN_STATUS.code());
        //需要验签且之前无需验签，则需要重置验签状态
        if (CheckSignStatus._3.getCode().equals(checkSignStatus)) {
            setVerifySignField(orgEntity, CheckSignStatus._0.getCode());
        }
    }

    /**
     * 重置验签状态
     *
     * @param orgEntity   orgEntity
     * @param checkStatus checkStatus
     */
    private void setVerifySignField(final JSONObject orgEntity, final String checkStatus) {
        orgEntity.put(EntityMeta.Ticket.CHECK_SIGN_STATUS.code(), checkStatus);
        orgEntity.put(EntityMeta.Ticket.CHECK_SIGN_REMARK.code(), StringUtils.EMPTY);
        orgEntity.put(EntityMeta.Ticket.CHECK_SIGN_TASK_ID.code(), StringUtils.EMPTY);
        orgEntity.put(EntityMeta.Ticket.CHECK_SIGN_USER_ID.code(), 0L);
        orgEntity.put(EntityMeta.Ticket.CHECK_SIGN_USER_NAME.code(), StringUtils.EMPTY);
    }

    /**
     * 清空重复，复用字段
     *
     * @param jsonObject json对象
     * @param ticketId   单证ID
     * @param ticketCode 单证代码
     */
    private void clearRepeatReuse(final JSONObject jsonObject, final Long ticketId, final String ticketCode) {
        //删除重复关系
        billTicketRelationService.deleteBillTicketRelation(ticketId, ticketCode);
        billTicketReuseService.deleteBillTicketReuse(ticketId, ticketCode);
        jsonObject.put("is_repeat", YesNo._0.getCode());
        jsonObject.put("repeat_tag", StringUtils.EMPTY);
        jsonObject.put("is_reuse", YesNo._0.getCode());
        jsonObject.put("reuse_tag", StringUtils.EMPTY);
    }

    /**
     * 重算其他单证
     *
     * @param repeatTag repeatTag
     * @param reuseTag  reuseTag
     */
    private void checkOtherTicket(final String repeatTag, final String reuseTag) {
        if (!StringHelp.safeIsEmpty(repeatTag)) {
            final List<BillTicketRelation> relationEntityList = billTicketRelationService.selectBillTicketRelation(repeatTag);
            if (!CollectionUtils.isEmpty(relationEntityList)) {
                if (relationEntityList.size() == 1) {
                    billTicketRelationService.deleteBillTicketRelation(relationEntityList.get(0).getTicketId(), relationEntityList.get(0).getTicketCode());
                    final Map<String, Object> update = Maps.newHashMap();
                    update.put("is_repeat", YesNo._0.getCode());
                    update.put("repeat_tag", StringUtils.EMPTY);
                    ticketService.updateTicketByParam(relationEntityList.get(0).getTicketId(), relationEntityList.get(0).getTicketCode(), update);
                }
                relationEntityList.forEach(r -> billImageTicketService.sendTicketMq(r.getTenantId(), r.getTicketId(), r.getTicketCode(), "编辑单证保存后重算其他单证重复"));
            }
        }
        if (!StringHelp.safeIsEmpty(reuseTag)) {
            final List<BillTicketReuse> reuseEntities = billTicketReuseService.selectBillTicketReuse(reuseTag);
            if (!CollectionUtils.isEmpty(reuseEntities)) {
                if (reuseEntities.size() == 1) {
                    billTicketReuseService.deleteBillTicketReuse(reuseEntities.get(0).getTicketId(), reuseEntities.get(0).getTicketCode());
                    final Map<String, Object> update = Maps.newHashMap();
                    update.put("is_reuse", YesNo._0.getCode());
                    update.put("reuse_tag", StringUtils.EMPTY);
                    ticketService.updateTicketByParam(reuseEntities.get(0).getTicketId(), reuseEntities.get(0).getTicketCode(), update);
                }
                reuseEntities.forEach(r -> billImageTicketService.sendTicketMq(r.getTenantId(), r.getTicketId(), r.getTicketCode(), "编辑单证保存后重算其他单证复用"));
            }
        }
    }

    /**
     * 是否自动发验真
     */
    protected void isSendVerify(final Long ticketId, final String ticketCode, final IAuthorizedUser authorizedUser) {
    }

    /**
     * 获取公司编号
     */
    protected void getCompanyNo(final Long tenantId, final String ticketCode, final JSONObject jsonObject) {
    }

    /**
     * JXCPX-360: 上传的pdf增值税电子普通发票，修改发票类型为增值税普通发票，显示无源文件，再次修改发票类型为增值税电子普通发票，还是显示无源文件 处理单证编辑类型时is_source_file错乱问题
     *
     * @param imageFile 影像文件
     * @param formData  单证对象
     */
    protected void processTicketSourceFile(final ImageFile imageFile, final JSONObject formData) {
        if (formData == null) {
            return;
        }
        formData.put(EntityMeta.Ticket.IS_SOURCE_FILE.code(), YesNo._0.getCode());
        if (imageFile == null) {
            return;
        }
        final String invoiceType = formData.getString(EntityMeta.Ticket.INVOICE_TYPE.code());
        if (Arrays.asList(InvoiceType.SE.getCode(), InvoiceType.CE.getCode(), InvoiceType.CB.getCode(), InvoiceType.CT.getCode(), InvoiceType.CD.getCode()).contains(invoiceType)) {
            formData.put(EntityMeta.Ticket.IS_SOURCE_FILE.code(), YesNo._1.getCode());
        }
    }

    /**
     * 编辑变更发票号码,代码,联次 若is_repeat则重算关系(不变更单证类型)
     *
     * @param formData    formData
     * @param ticket      ticket
     * @param subTicketId subTicketId
     */
    protected boolean checkRepeatTicket(final Long tenantId, final JSONObject formData, final Ticket ticket, final Long subTicketId) {
        if (!formData.getString("invoice_no").equals(StringHelp.safeToString(ticket.getInvoiceNo()))
            || !formData.getString("invoice_code").equals(StringHelp.safeToString(ticket.getInvoiceCode()))
            || !formData.getString("invoice_sheet").equals(StringHelp.safeToString(ticket.getInvoiceSheet()))
            || !formData.getString("vehicle_sheet").equals(StringHelp.safeToString(ticket.getInvoiceSheet()))) {
            billImageTicketService.handleTicketSheet(tenantId, Collections.singletonList(ticket), OperateEnum.DELETE, ticket.getBillCode());
        }

        //不重复则不计算关系
        if (ticketRelationService.newRelationHandle(tenantId)) {
            final List<TicketRelation> ticketRelations = ticketRelationService.selectRelations(Collections.singletonList(subTicketId));
            if (ticketRelations.stream().noneMatch(relation -> TicketRelType.REPEAT.getCode().equals(relation.getRelType()))) {
                return false;
            }
        } else {
            if (!YesNo._1.getCode().equals(ticket.getIsRepeat())) {
                return false;
            }
        }
        final Map<String, Object> sourceTicket = ticketService.selectByTicketCode(ticket.getTicketCode(), subTicketId);
        if (ValidatorUtil.isEmpty(sourceTicket)) {
            return false;
        }
        //字典
        final String ticketCode = formData.getString("ticket_code");
        final List<ConfigDictionaryItem> dictionaryItemList = configDictionaryService.selectItems(tenantId, ConfigConstants.CONFIG_DICT_CODE_TICKET_REPEAT_FIELD);
        if (ValidatorUtil.isEmpty(dictionaryItemList)) {
            return false;
        }
        final Map<String, ConfigDictionaryItem> dictionaryMap = dictionaryItemList.stream().collect(Collectors.toMap(ConfigDictionaryItem::getItemCode, Function.identity(), (k1, k2) -> k1));
        if (!dictionaryMap.containsKey(ticketCode)) {
            return false;
        }
        final String configField = dictionaryMap.get(ticketCode).getItemValue();
        final JSONObject ticketData = JSONObject.parseObject(JSONObject.toJSONString(ticket));
        final boolean isChange = Arrays.stream(configField.split(","))
                                       .anyMatch(field -> formData.getString(field) != null && !formData.getString(field).equals(ticketData.getString(field)));
        if (isChange) {
            billImageTicketService.checkTicketRepeatAndReuse(tenantId, Collections.singletonList(ticket.getImageId()), OperateEnum.DELETE, ticket.getBillCode());
            billImageTicketService.updateRecogBillInfo(tenantId, ticket.getBillCode());
            return true;
        }
        return false;

    }

    /**
     * 处理单证修改标识
     *
     * @author liming
     * @date 2021/4/8 17:21
     */
    public void handleTicketModifyFlag(final Long tenantId, final Map<String, Object> sourceTicketMap, final JSONObject modifyTicket) {
        if (sourceTicketMap == null || modifyTicket == null) {
            return;
        }
        final String ticketInitialValue = String.valueOf(sourceTicketMap.get(EntityMeta.Ticket.TICKET_INITIAL_VALUE.code()));
        final Map<String, Object> update = ticketEditFacade.modifyFlag(ticketInitialValue, modifyTicket, ChangeTrigger.EDIT);
        modifyTicket.putAll(update);
    }

    /**
     * 多票新增标识逻辑
     *
     * @author liming
     * @date 2021/4/9 11:08
     */
    public void handleManyTicketAddFlag(final BaseBill billEntity, final JSONObject jsonObject) {
        if (billEntity == null || !BillDataStatus._4.getCode().equals(billEntity.getBillDataStatus()) || jsonObject == null) {
            return;
        }
        jsonObject.put(EntityMeta.Ticket.TICKET_INITIAL_VALUE.code(), JSONObject.toJSONString(jsonObject, SerializerFeature.WriteMapNullValue));
        jsonObject.put(EntityMeta.Ticket.IS_ADD.code(), YesNo._1.getCode());
    }

    /**
     * 修改影像类型后重置单证新增、修改标识
     *
     * @author liming
     * @date 2021/4/15 18:29
     */
    public void resetTicketAddAndChangeFlag(final JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        jsonObject.put(EntityMeta.Ticket.IS_ADD.code(), YesNo._0.getCode());
        jsonObject.put(EntityMeta.Ticket.TICKET_INITIAL_VALUE.code(), jsonObject.toJSONString());
        //没有配置比对字段则不添加改字
        final Long tenantId = jsonObject.getLong(EntityMeta.Ticket.TENANT_ID.code());
        final String ticketCode = jsonObject.getString(EntityMeta.Ticket.TICKET_CODE.code());
        final List<TicketCompareConfig> ticketCompareConfigList = configService.selectDict(tenantId, DictEnum.TICKET_COMPARE_CONFIG.getCode(), TicketCompareConfig.class);
        if (ValidatorUtil.isEmpty(ticketCompareConfigList)) {
            jsonObject.put(EntityMeta.Ticket.IS_CHANGE.code(), YesNo._0.getCode());
            jsonObject.put(EntityMeta.Ticket.TICKET_CHANGE_VALUE.code(), StringUtils.EMPTY);
            return;
        }
        final TicketCompareConfig ticketCompareConfig = ticketCompareConfigList.stream()
                                                                               .filter(item -> "1".equals(item.getCheckType()) && ticketCode.equals(item.getEntityCode()))
                                                                               .findFirst().orElse(null);
        if (ticketCompareConfig == null) {
            jsonObject.put(EntityMeta.Ticket.IS_CHANGE.code(), YesNo._0.getCode());
            jsonObject.put(EntityMeta.Ticket.TICKET_CHANGE_VALUE.code(), StringUtils.EMPTY);
            return;
        }
        jsonObject.put(EntityMeta.Ticket.IS_CHANGE.code(), YesNo._1.getCode());
        jsonObject.put(EntityMeta.Ticket.TICKET_CHANGE_VALUE.code(), JSONObject.toJSONString(Collections.singletonList(EntityMeta.Ticket.TICKET_CODE.code())));
    }

    /**
     * 处理单证invoice_type字段问题
     *
     * @param request    请求
     * @param jsonObject json对象
     * @return void
     * @author rongying
     * @date 2021/4/23 15:23
     */
    public void handleInvoiceType(final SaveTicketDataRequest request, final JSONObject jsonObject) {
        if (EntityMeta.TicketInvoice.code().equals(request.getTicketCode())) {
            return;
        }
        final InvoiceTypeEnum invoiceTypeEnum = InvoiceTypeEnum.fromTicketCode(request.getTicketCode());
        if (null == invoiceTypeEnum) {
            return;
        }
        jsonObject.put(EntityMeta.Ticket.INVOICE_TYPE.code(), invoiceTypeEnum.getCode());
    }

    /**
     * 编辑判断是否重算连号
     *
     * @param tenantId     租户ID
     * @param newInvoiceNo newInvoiceNo
     * @param ticket       ticket
     * @param isUpdateType isUpdateType
     * @return void
     * @author rongying
     * @date 2021/5/12 15:43
     */
    public void checkTicketConsecutiveNumber(final Long tenantId, final String newInvoiceNo, final Ticket ticket, final boolean isUpdateType) {
        //YXDA-8834 【新城悦】同单据内两张出租车连号，修改A发票得发票代码，B发票还存在连号异常
        // 发票代码、发票号码、单据号码、票种等都可能影响串号，此处不做拦截
        /*//未修改类型
        if(!isUpdateType) {
            //发票号码未修改，返回
            if (ValidatorUtil.isNotEmpty(newInvoiceNo) && newInvoiceNo.equals(ticket.getInvoiceNo())){
                return;
            }
        }*/
        logger.info("单证编辑保存触发连号，原发票号码：{}，新发票号码：{}", ticket.getInvoiceNo(), newInvoiceNo);
        beanDispatcher.dispatch(tenantId, DefaultBillImageTicketServiceImpl.class).checkConsecutiveNumber(tenantId, new JSONObject(ticket.toOQSMap()));
    }

    /**
     * 保存校验前置条件
     *
     * @param ticket ticket
     * @return java.lang.String
     * @author rongying
     * @date 2021/8/5 13:44
     */
    public String checkSaveCmdBefore(final Ticket ticket) {
        return StringUtils.EMPTY;
    }

    /**
     * 附件移除字段
     *
     * @param ticketCode 单证代码
     * @param jsonObject json对象
     * @return void
     * @author rongying
     * @date 2021/9/13 11:44
     */
    public void removeField(final String ticketCode, final JSONObject jsonObject) {
        if (!EntityMeta.TicketAttachment.code().equals(ticketCode)) {
            return;
        }
        jsonObject.put(EntityMeta.Ticket.INVOICE_CODE.code(), StringUtils.EMPTY);
        jsonObject.put(EntityMeta.Ticket.INVOICE_NO.code(), StringUtils.EMPTY);
        jsonObject.put(EntityMeta.Ticket.PURCHASER_TAX_NO.code(), StringUtils.EMPTY);
        jsonObject.put(EntityMeta.Ticket.PURCHASER_NAME.code(), StringUtils.EMPTY);
        jsonObject.put(EntityMeta.Ticket.SELLER_TAX_NO.code(), StringUtils.EMPTY);
        jsonObject.put(EntityMeta.Ticket.SELLER_NAME.code(), StringUtils.EMPTY);
        jsonObject.put(EntityMeta.Ticket.AMOUNT_WITH_TAX.code(), 0);
        jsonObject.put(EntityMeta.Ticket.AMOUNT_WITHOUT_TAX.code(), 0);
        jsonObject.put(EntityMeta.Ticket.TAX_AMOUNT.code(), 0);
        //JXCPX-1517 中南集团#红冲的发票，修改影像类型为附件，没有重置发票的红冲状态
        jsonObject.put(EntityMeta.Ticket.INVOICE_STATUS.code(), InvoiceStatus._1.getCode());
        //JXCPX-776 移动端上传附件时，我的票夹显示的附件日期为空，但编辑影像从发票到单证时，显示的日期为1970，期望：与正常上传附件显示一致，均无发票日期
        //JXCPX-8832 【屈臣氏】移动端我的票夹 修改附件日期 不成功
        if ("0".equals(jsonObject.getString(EntityMeta.Ticket.INVOICE_DATE.code()))) {
            jsonObject.put(EntityMeta.Ticket.INVOICE_DATE.code(), EmptyValue.emptyValue);
        }
        //JXCPX-1860 弘阳地产#发票验证中，编辑发票不点击保存，验证回来后，点击保存覆盖了验真回来的信息
        jsonObject.remove(EntityMeta.Ticket.CHECK_STATUS.code());
        jsonObject.remove(EntityMeta.Ticket.CHECK_REMARK.code());
    }

    /**
     * @param ticketCode 单证代码
     * @param jsonObject json对象
     * @return void
     * @author liuhongbin
     * @date 2021/12/14 15:09
     */
    private void amountWithTax(final String ticketCode, final JSONObject jsonObject) {
        if (!EntityMeta.TicketPlane.code().equals(ticketCode)) {
            return;
        }
        //JXCPX-3990 【飞机票】【含税金额】编辑飞机票信息后 含税金额值计算不正确
        final BigDecimal total = jsonObject.getBigDecimal(TicketPlane.TOTAL.code());
        jsonObject.put(EntityMeta.Ticket.AMOUNT_WITH_TAX.code(), total);
    }

    /**
     * 编辑校验组织id
     *
     * @param tenantId          租户id
     * @param oldPurchaserTaxNo 修改前税号
     * @param jsonObject        修改后发票信息
     * @return void
     * @author rongying
     * @date 2022/2/8 15:05
     */
    private void checkOrgId(final Long tenantId, final String oldPurchaserTaxNo, final JSONObject jsonObject) {
        if (null == jsonObject) {
            return;
        }
        //大润发区域id
        if (ValidatorUtil.isNotEmpty(jsonObject.get("area.orgId"))) {
            jsonObject.put(EntityMeta.Ticket.AREA_ID.code(), jsonObject.get("area.orgId"));
            jsonObject.put(EntityMeta.Ticket.AREAS_ID.code(), jsonObject.get("area.orgId"));
        }
        if (ValidatorUtil.isNotEmpty(jsonObject.get("area.orgCode"))) {
            jsonObject.put(EntityMeta.Ticket.AREA_CODE.code(), jsonObject.get("area.orgCode"));
        }
        if (ValidatorUtil.isNotEmpty(jsonObject.get("area.orgName"))) {
            jsonObject.put(EntityMeta.Ticket.AREA_NAME.code(), jsonObject.get("area.orgName"));
        }
        if (ValidatorUtil.isNotEmpty(jsonObject.get("areas.orgId"))) {
            jsonObject.put(EntityMeta.Ticket.AREA_ID.code(), jsonObject.get("areas.orgId"));
            jsonObject.put(EntityMeta.Ticket.AREAS_ID.code(), jsonObject.get("areas.orgId"));
        }
        if (ValidatorUtil.isNotEmpty(jsonObject.get("areas.orgCode"))) {
            jsonObject.put(EntityMeta.Ticket.AREA_CODE.code(), jsonObject.get("areas.orgCode"));
        }
        if (ValidatorUtil.isNotEmpty(jsonObject.get("areas.orgName"))) {
            jsonObject.put(EntityMeta.Ticket.AREA_NAME.code(), jsonObject.get("areas.orgName"));
        }
        final String newTaxNo = jsonObject.getString(EntityMeta.Ticket.PURCHASER_TAX_NO.code());
        //修改税号为空，清空组织信息
        if (ValidatorUtil.isEmpty(newTaxNo)) {
            jsonObject.put("org_id", 0L);
            jsonObject.put("org_code", StringUtils.EMPTY);
            jsonObject.put("org_name", StringUtils.EMPTY);
            return;
        }
        //组织id为空，查询
        if (ValidatorUtil.isEmpty(jsonObject.getLong(EntityMeta.Ticket.ORG_ID.code()))) {
            imageOrgUtils.getOrgId(tenantId, jsonObject, newTaxNo);
            return;
        }
        //组织id不为空，校验税号是否修改
        if (newTaxNo.equals(oldPurchaserTaxNo)) {
            return;
        }
        imageOrgUtils.getOrgId(tenantId, jsonObject, newTaxNo);
    }

    protected void checkCreateAmount(final JSONObject jsonObject) {
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.TAX_AMOUNT.code()))) {
            jsonObject.remove(EntityMeta.Ticket.TAX_AMOUNT.code());
        }
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.AMOUNT_WITHOUT_TAX.code()))) {
            jsonObject.remove(EntityMeta.Ticket.AMOUNT_WITHOUT_TAX.code());
        }
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.AMOUNT_WITH_TAX.code()))) {
            jsonObject.remove(EntityMeta.Ticket.AMOUNT_WITH_TAX.code());
        }
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.CHARGE_UP_AMOUNT.code()))) {
            jsonObject.remove(EntityMeta.Ticket.CHARGE_UP_AMOUNT.code());
        }
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.PAYMENT_AMOUNT.code()))) {
            jsonObject.remove(EntityMeta.Ticket.PAYMENT_AMOUNT.code());
        }
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.BALANCE_AMOUNT.code()))) {
            jsonObject.remove(EntityMeta.Ticket.BALANCE_AMOUNT.code());
        }
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.USED_AMOUNT.code()))) {
            jsonObject.remove(EntityMeta.Ticket.USED_AMOUNT.code());
        }
    }

    protected void checkUpdateAmount(final JSONObject jsonObject) {
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.TAX_AMOUNT.code()))) {
            jsonObject.put(EntityMeta.Ticket.TAX_AMOUNT.code(), EmptyValue.emptyValue);
        }
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.AMOUNT_WITHOUT_TAX.code()))) {
            jsonObject.put(EntityMeta.Ticket.AMOUNT_WITHOUT_TAX.code(), EmptyValue.emptyValue);
        }
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.AMOUNT_WITH_TAX.code()))) {
            jsonObject.put(EntityMeta.Ticket.AMOUNT_WITH_TAX.code(), EmptyValue.emptyValue);
        }
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.CHARGE_UP_AMOUNT.code()))) {
            jsonObject.put(EntityMeta.Ticket.CHARGE_UP_AMOUNT.code(), EmptyValue.emptyValue);
        }
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.PAYMENT_AMOUNT.code()))) {
            jsonObject.put(EntityMeta.Ticket.PAYMENT_AMOUNT.code(), EmptyValue.emptyValue);
        }
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.BALANCE_AMOUNT.code()))) {
            jsonObject.put(EntityMeta.Ticket.BALANCE_AMOUNT.code(), EmptyValue.emptyValue);
        }
        if (StringUtils.equals("", jsonObject.getString(EntityMeta.Ticket.USED_AMOUNT.code()))) {
            jsonObject.put(EntityMeta.Ticket.USED_AMOUNT.code(), EmptyValue.emptyValue);
        }
    }

}