package com.xforceplus.elephant.image.controller.ticket.process.save;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.image.client.model.SaveTicketDataRequest;
import com.xforceplus.elephant.image.core.business.enums.InvoiceTypeEnum;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.Arrays;
import org.springframework.stereotype.Service;

@Dispatch(tenantCode = "LPPZ")
@Service
public class LPPZSaveTicketDataProcess extends DefaultSaveTicketDataProcess {

    /**
     * 处理单证invoice_type字段问题
     *
     * @param request    请求
     * @param jsonObject json对象
     * @return void
     * @author rongying
     * @date 2021/7/28 10:59
     */
    @Override
    public void handleInvoiceType(SaveTicketDataRequest request, JSONObject jsonObject) {
        if (Arrays.asList(EntityMeta.TicketInvoice.code(), EntityMeta.TicketMachine.code()).contains(request.getTicketCode())) {
            return;
        }
        final InvoiceTypeEnum invoiceTypeEnum = InvoiceTypeEnum.fromTicketCode(request.getTicketCode());
        if (null == invoiceTypeEnum) {
            return;
        }
        jsonObject.put(EntityMeta.Ticket.INVOICE_TYPE.code(), invoiceTypeEnum.getCode());
    }

}