package com.xforceplus.elephant.image.controller.batch.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.core.business.application.collect.batch.domain.BatchBean;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@RequiredArgsConstructor
public class GetBatchTaskProcess extends AbstractProcess<BaseRequest, BatchBean> {

    private final BatchService batchService;

    @Override
    protected CommonResponse<BatchBean> process(BaseRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        return CommonResponse.ok("成功", batchService.selectProcess(user.getId()));
    }

}
