package com.xforceplus.elephant.image.controller.billdata.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.RedisUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetBillCodeProcess extends AbstractKeyProcess<String, BaseRequest, String> {

    @Autowired
    private RedisUtils redisUtils;

    @Override
    protected CommonResponse<String> process(String keyCode, BaseRequest request) throws RuntimeException {
        if (!redisUtils.hasKey(keyCode)) {
            return CommonResponse.failed("影像地址无效.");
        }
        final String result = (String) redisUtils.get(keyCode);
        if (StringHelp.safeIsEmpty(result)) {
            return CommonResponse.failed("影像地址无效.");
        }
        final JSONObject jsonObject = JSONObject.parseObject(result);
        if (jsonObject.containsKey("requestNo") && jsonObject.get("requestNo") != null) {
            return CommonResponse.ok("成功", jsonObject.get("requestNo").toString());
        }
        return CommonResponse.failed("数据不存在，请检查.");
    }

}
