package com.xforceplus.elephant.image.controller.billdata.process;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.ReCheckBillRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.operationlog.OperationLogService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationEntity;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import java.util.HashMap;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@RequiredArgsConstructor
@Service
public class ReCheckBillProcess extends AbstractProcess<ReCheckBillRequest, Boolean> {

    private final BaseBillService baseBillService;
    private final MQUtils rabbitmqUtils;
    private final OperationLogService operationLogService;

    @Override
    protected void check(ReCheckBillRequest request) throws ValidationException {
        checkEmpty(request.getBillCode(), "billCodes不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(ReCheckBillRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final BaseBill billEntity = baseBillService.selectBaseBillByCode(user.getTenantId(), request.getBillCode());
        checkEmpty(billEntity, "单据不存在");
        final Map<String, Object> pushMap = Maps.newHashMap();
        pushMap.put("source", "重算单据");
        pushMap.put("tenantId", user.getTenantId());
        pushMap.put("billCode", billEntity.getBillCode());
        pushMap.put("billTypeCode", billEntity.getBillTypeCode());
        final Map<String, Object> headers = new HashMap<>();
        headers.put(TENANT_CODE, user.getTenantCode());
        rabbitmqUtils.sendByDirectExchange(MQEnum.RE_CHECK_BILL.getQueue(), pushMap, headers);
        operationLogService.insertOperationLog(OperationEntity.BILL.getCode(), request.getBillCode(),
            OperationType.RE_CHECK_BILL.getCode(), user.getUsername(), "");
        return CommonResponse.ok("发起重算成功，请稍后确认");
    }

}
