package com.xforceplus.elephant.image.controller.compare.ticket.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BackBaseBillRequest;
import com.xforceplus.elephant.image.client.model.BackTicketsBean;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.service.TicketService;
import com.xforceplus.elephant.image.core.util.RequestBuilder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.AuditBackStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import java.util.List;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
@RequiredArgsConstructor
public class CompareSelectBackTicketsProcess extends AbstractProcess<BackBaseBillRequest, BackTicketsBean> {

    private final TicketService ticketService;

    @Override
    protected void check(BackBaseBillRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCodes(), "单据号不能为空");
    }

    @Override
    protected CommonResponse<BackTicketsBean> process(BackBaseBillRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final long total = ticketService.selectTicketByBillCodes(user.getTenantId(), request.getBillCodes(), EntityMeta.CompareTicket.code()).size();
        final RequestBuilder requestBuilder = new RequestBuilder()
            .field(EntityMeta.Ticket.BILL_CODE.code(), ConditionOp.in, request.getBillCodes())
            .field(EntityMeta.Ticket.AUDIT_BACK_STATUS.code(), ConditionOp.eq, AuditBackStatus._1.getCode());
        final List<Ticket> tickets = ticketService.selectTicketByParams(user.getTenantId(), requestBuilder, EntityMeta.CompareTicket.code());
        return CommonResponse.ok("成功", BackTicketsBean.builder().total(total).tickets(tickets).build());
    }

}
