package com.xforceplus.elephant.image.controller.image.process;

import com.xforceplus.elephant.basecommon.vaildate.Validator;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.DownloadImageFileRequest;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.imagefile.ImageFileService;
import com.xforceplus.elephant.image.core.facade.application.push.download.DownloadFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ImageFile;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/**
 * 单据详情页下载影像文件
 *
 * @author rongying
 * @date 2021/4/13 17:42
 */
@Slf4j
@RequiredArgsConstructor
@Service
public class DownloadImageFileProcess implements Validator {

    private final ImageService imageService;
    private final ImageFileService imageFileService;
    private final DownloadFacade downloadFacade;

    protected void check(DownloadImageFileRequest request) throws ValidationException {
        checkEmpty(request.getImageId(), "影像ID不能为空");
    }

    public ResponseEntity<byte[]> execute(DownloadImageFileRequest request) {
        check(request);
        return process(request);
    }

    protected ResponseEntity<byte[]> process(DownloadImageFileRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final Image image = imageService.selectOne(request.getImageId());
        if (null == image) {
            throw new ValidationException("影像数据为空，请检查.");
        }
        if (ValidatorUtil.isEmpty(image.getFileId())) {
            throw new ValidationException("影像对应文件数据不存在，无法下载.");
        }
        //查询文件
        final ImageFile imageFile = imageFileService.selectOne(image.getFileId());
        if (null == imageFile) {
            throw new ValidationException("影像对应文件数据不存在，无法下载.");
        }
        final IAuthorizedUser user = UserInfoHolder.get();// 获取登录用户上下文
        if (null == user) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        downloadFacade.downloadImageFile(user, request.getImageId(), baos);
        final byte[] bytes = baos.toByteArray();
        final String name = ValidatorUtil.isEmpty(imageFile.getAttachmentName()) ? imageFile.getFileName() : imageFile.getAttachmentName();
        String encodedName = name + imageFile.getFileSuffix();
        try {
            encodedName = URLEncoder.encode(name + imageFile.getFileSuffix(), "UTF-8");
        } catch (UnsupportedEncodingException e) {
            log.error("文件名处理失败", e);
        }
        return ResponseEntity.ok()
            .header("Content-Disposition", "attachment;fileName=" + encodedName)
            .contentType(MediaType.APPLICATION_OCTET_STREAM)
            .contentLength(bytes.length).body(bytes);
    }

}
