package com.xforceplus.elephant.image.controller.image.process;

import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.MoveImageRequest;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.Arrays;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MoveImageProcess extends AbstractKeyProcess<Long, MoveImageRequest, Boolean> {

    @Autowired
    private ImageService imageService;
    @Autowired
    private BillImageTicketService billImageTicketService;

    @Override
    protected void check(Long imageId, MoveImageRequest request) throws ValidationException {
        super.check(imageId, request);
        checkEmpty(request.getBillCode(), "单据CODE不能为空");
        checkEmpty(request.getFileOrder(), "顺序不能为空");
        if (request.getFileOrder() == 1) {
            throw new ValidationException("不能移动影像到封面位置");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(Long imageId, MoveImageRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final Image entity = imageService.selectOne(authorizedUser.getTenantId(), imageId);
        checkEmpty(entity, "移动的影像不存在");
        if (ImageType._1.getCode().equals(entity.getImageType())) {
            throw new ValidationException("不能移动封面");
        }
        if (!request.getBillCode().equals(entity.getBillCode())) {
            throw new ValidationException("移动的影像不属于该单据：" + request.getBillCode());
        }
        if (!Arrays.asList(RecStatus._2.getCode(), RecStatus._3.getCode()).contains(String.valueOf(entity.getRecStatus()))) {
            throw new ValidationException("移动的影像未识别完成");
        }
        final boolean result = imageService.moveImage(entity, request.getFileOrder());
        billImageTicketService.onlyResetLevel(authorizedUser.getTenantId(), request.getBillCode());
        return CommonResponse.ok("成功", result);
    }

}
