package com.xforceplus.elephant.image.controller.image.process;

import com.xforceplus.elephant.basecommon.help.FileUtils;
import com.xforceplus.elephant.basecommon.help.RandomUtil;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.InsertImageDTO;
import com.xforceplus.elephant.image.client.model.SourceFileUploadRequest;
import com.xforceplus.elephant.image.core.business.application.collect.task.domain.FileTransformTypeConfig;
import com.xforceplus.elephant.image.core.business.enums.FileTypeEnum;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.imagefile.ImageFileService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.facade.application.collect.bill.BillFacade;
import com.xforceplus.elephant.image.core.facade.application.collect.upload.UploadFacade;
import com.xforceplus.elephant.image.core.facade.dto.upload.UploadImageDto;
import com.xforceplus.elephant.image.core.facade.dto.upload.UploadImageRequestDto;
import com.xforceplus.elephant.image.mapper.UploadMapper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.TransformScene;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ImageFile;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 电票源文件替换
 *
 * @author liming
 * @date 2021/9/8 10:43
 */
@Service
public class SourceFileUploadProcess extends AbstractProcess<SourceFileUploadRequest, List<Long>> {

    @Autowired
    private BillFacade billFacade;
    @Autowired
    private ImageFileService imageFileService;
    @Autowired
    private UploadFacade uploadFacade;
    @Autowired
    private UploadMapper uploadMapper;
    @Autowired
    private ImageService imageService;

    @Autowired
    private BillImageTicketService billImageTicketService;

    @Override
    protected void check(SourceFileUploadRequest request) throws ValidationException {
        checkEmpty(request.getImageId(), "imageId不能为空");
        checkEmpty(request.getInsertImageDTOList(), "操作对象不能为空");
        for (InsertImageDTO entity : request.getInsertImageDTOList()) {
            checkEmpty(entity.getFileStream(), "文件流不能为空");
            checkEmpty(entity.getFileType(), "文件类型不能为空");
            final FileTypeEnum fileTypeEnum = FileTypeEnum.fromCode(entity.getFileType());
            checkEmpty(fileTypeEnum, "不支持该类型文件" + entity.getFileType());
        }
    }

    @Override
    protected CommonResponse<List<Long>> process(SourceFileUploadRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (ValidatorUtil.isEmpty(authorizedUser)) {
            return CommonResponse.failed("用户信息获取失败!");
        }
        //1-获取当前补扫影像
        final Image imageEntity = imageService.selectOne(authorizedUser.getTenantId(), request.getImageId());
        if (imageEntity == null) {
            return CommonResponse.failed("源文件上传失败，影像不存在!");
        }

        billImageTicketService.deleteImageAndTicketByImageIds(authorizedUser.getTenantId(), Arrays.asList(imageEntity.getId()));

        BaseBill billEntity = null;
        final String[] isPublic = {request.getIsPublic().toString()};
        if (ValidatorUtil.isNotEmpty(request.getBillCode())) {
            billEntity = billFacade.selectBaseBillByCode(authorizedUser.getTenantId(), request.getBillCode(), EntityMeta.BaseBill.code());
            isPublic[0] = ValidatorUtil.isNotEmpty(billEntity) ? billEntity.getIsPublic() : request.getIsPublic().toString();
        }
        final String batchNo = System.currentTimeMillis() + String.valueOf(RandomUtil.randomInt(99999));
        //2-获取文件转换字典配置
        final FileTransformTypeConfig fileTransformTypeConfig = imageFileService.getFileTransformTypeConfig(authorizedUser.getTenantId());
        //3-上传
        final List<Long> imageIds = new ArrayList<>();
        //3-0 存在zip，解析完在上传
        final UploadImageRequestDto requestDto = uploadMapper.map(request);
        uploadFacade.initSystemField(requestDto, authorizedUser);
        final List<UploadImageDto> resultList = uploadFacade.checkZipFile(requestDto.getUploadImageDtoList(), authorizedUser.getTenantId());
        final BaseBill finalBillEntity = billEntity;
        resultList.forEach(imageDto -> {
            //3-1初始化影像文件
            final ImageFile imageFile = uploadFacade.initImageFile(requestDto);
            imageFile.setTransformScene(TransformScene.TRANS_REC.getCode());
            //3-2获取影像上传地址,存储 fileKey,fileName
            final String fileUrl = uploadFacade.getUploadImageUrl(authorizedUser.getTenantId(), authorizedUser.getId(), imageDto.getFileStream(), imageDto.getFileType(), imageFile);
            final String fileSuffix = ValidatorUtil.isNotEmpty(FileUtils.getFileSuffix(fileUrl)) ? FileUtils.getFileSuffix(fileUrl) : imageDto.getFileType();
            imageFile.setFileSuffix(fileSuffix);
            imageFile.setFileUrl(fileUrl);
            imageFile.setAttachmentName(imageDto.getFileName());
            imageFile.setFileOrder(imageEntity.getFileOrder());
            imageFile.setIsPublic(isPublic[0]);
            imageFile.setBatchNo(batchNo);

            //3-3初始化影像
            final Image image = uploadFacade.initImage(requestDto);
            image.setFileUrl(fileUrl);
            image.setFileUrlHandle(fileUrl);
            image.setFileType(fileSuffix);
            image.setFileTypeHandle(fileSuffix);
            image.setFileOrder(imageEntity.getFileOrder());
            image.setIsPublic(isPublic[0]);
            image.setBatchNo(batchNo);
            image.setFileName(imageDto.getFileName());
            //3-4上传
            final Long imageId = uploadFacade.executeUpload(finalBillEntity, fileSuffix, image, imageFile, fileTransformTypeConfig);
            if (ValidatorUtil.isNotEmpty(imageId)) {
                imageIds.add(imageId);
            }
        });
        return CommonResponse.ok("上传成功!", imageIds);
    }

}
