package com.xforceplus.elephant.image.controller.specialinvoice.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.SaveSpecialInvoiceRequest;
import com.xforceplus.elephant.image.core.business.application.config.common.domain.SpecialInvoiceConfig;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.business.infrastructure.domain.UltramanSpecialInvoiceDTO;
import com.xforceplus.elephant.image.core.business.infrastructure.domain.UltramanSpecialInvoiceResponse;
import com.xforceplus.elephant.image.core.business.infrastructure.port.SpecialInvoiceService;
import com.xforceplus.elephant.image.core.domain.config.ConfigDictionaryService;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@RequiredArgsConstructor
@Service
public class SaveSpecialInvoiceProcess extends AbstractProcess<SaveSpecialInvoiceRequest, Boolean> {

    private final TicketService ticketService;
    private final BillImageTicketService billImageTicketService;
    private final SpecialInvoiceService specialInvoiceService;
    private final ConfigDictionaryService configDictionaryService;

    @Override
    protected void check(SaveSpecialInvoiceRequest request) throws ValidationException {
        checkEmpty(request.getTicketId(), "单证id不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(SaveSpecialInvoiceRequest request) throws RuntimeException {
        final String error = handleSpecialInvoiceFlag(request);
        if (ValidatorUtil.isNotEmpty(error)) {
            return CommonResponse.failed(error);
        }
        // 重算
        final Map<String, Object> ticket = ticketService.selectByTicketCode(EntityMeta.Ticket.code(), request.getTicketId());
        if (ValidatorUtil.isEmpty(ticket)) {
            return CommonResponse.failed("未查询到该单证!");
        }
        final String ticketCode = StringHelp.safeToString(ticket.get(EntityMeta.Ticket.TICKET_CODE.code()));
        final Long tenantId = Long.valueOf(String.valueOf(ticket.get("tenant_id")));
        final Long imageId = Long.valueOf(String.valueOf(ticket.get("image_id")));
        final String billCode = StringHelp.safeToString(ticket.get("bill_code"));
        final JSONObject updateJson = billImageTicketService.checkTicketExceAndWarn(tenantId, new JSONObject(ticket));
        ticketService.updateTicketByParam(request.getTicketId(), ticketCode, updateJson);
        billImageTicketService.updateManyExceWarnData(imageId);
        //修改影像
        billImageTicketService.updateImageExceWarnData(tenantId, imageId);
        if (ValidatorUtil.isNotEmpty(billCode)) {
            billImageTicketService.updateRecogBillInfo(tenantId, billCode);
        }
        return CommonResponse.ok("保存成功");
    }

    /**
     * 处理特殊发票标记
     * @author rongying
     * @date 2023/6/28 10:14
     * @param request 参数
     * @return java.lang.String
     */
    private String handleSpecialInvoiceFlag(SaveSpecialInvoiceRequest request) {
        if (ValidatorUtil.isEmpty(request.getSpecialInvoiceFlag())) {
            return StringUtils.EMPTY;
        }
        final Ticket ticket = ticketService.selectBaseTicketById(request.getTicketId());
        if (null == ticket) {
            return "未查询到该单证!";
        }
        // 修改了特殊标记且与原来不一致，则更新发票特殊标记
        if (request.getSpecialInvoiceFlag().equals(ticket.getSpecialInvoiceFlag())) {
            return StringUtils.EMPTY;
        }
        final Map<String, Object> updateMap = new HashMap<>();
        updateMap.put(EntityMeta.Ticket.SPECIAL_INVOICE_FLAG.code(), request.getSpecialInvoiceFlag());
        ticketService.updateTicketByParam(ticket.getId(), ticket.getTicketCode(), updateMap);
        // 查询特殊明细配置
        final String config = configDictionaryService.select(ticket.getTenantId(), DictEnum.SPECIAL_INVOICE_CONFIG.getCode());
        if (ValidatorUtil.isEmpty(config)) {
            return StringUtils.EMPTY;
        }
        final List<SpecialInvoiceConfig> configList = JSONObject.parseArray(config, SpecialInvoiceConfig.class);
        final Optional<SpecialInvoiceConfig> configOptional = configList.stream().filter(r -> r.getValue().equals(request.getSpecialInvoiceFlag())).findFirst();
        // 修改后的特殊发票标记不是特殊行业，则删除原来的特殊行业明细
        if (!configOptional.isPresent()) {
            specialInvoiceService.removeSpecialInvoice(String.valueOf(ticket.getId()));
        }
        // 修改后的特殊发票标记是特殊行业，则查询是否与现在修改的一致，不一致则删除原来的特殊行业明细
        final UltramanSpecialInvoiceResponse<UltramanSpecialInvoiceDTO> response = specialInvoiceService.searchSpecialInvoice(String.valueOf(ticket.getId()));
        if (UltramanSpecialInvoiceResponse.SUCCESS.equals(response.getCode()) && null != response.getResult()) {
            final UltramanSpecialInvoiceDTO invoiceDTO = response.getResult();
            if (!invoiceDTO.getSpecialInvoiceFlag().equals(configOptional.get().getKylieSpecialFlag())) {
                specialInvoiceService.removeSpecialInvoice(String.valueOf(ticket.getId()));
            }
        }
        return StringUtils.EMPTY;
    }

}
