package com.xforceplus.elephant.image.controller.ticket.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BatchEditRequest;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.service.TicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.Ticket;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2025/4/8 15:42
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class BatchEditTicketProcess extends AbstractProcess<BatchEditRequest, Boolean> {

    private final TicketService ticketService;

    @Override
    protected void check(BatchEditRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getTicketIds())) {
            throw new ValidationException("单证ID不能为空");
        }
        if (ValidatorUtil.isEmpty(request.getEditContents())) {
            throw new ValidationException("编辑内容不能为空");
        }
        if (CollectionUtils.size(request.getTicketIds()) > 50) {
            throw new ValidationException("单证不能超过50个");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(BatchEditRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆.");
        }
        final Integer updated = ticketService.updateMulti(request.getTicketIds(), request.getEditContents(), Ticket.code());

        if (updated == 0) {
            return CommonResponse.failed("编辑失败.");
        }
        return CommonResponse.ok("编辑成功.");
    }

}
