package com.xforceplus.elephant.image.controller.ticket.process.save;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.enums.bill.ExtStatusEnum;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import org.springframework.stereotype.Service;

/**
 * 融创集团保存
 *
 * @author rongying
 * @date 2021/8/5 11:38
 */
@Dispatch(tenantCode = "RCJT")
@Service
public class RCJTSaveTicketDataProcess extends DefaultSaveTicketDataProcess {

    /**
     * 保存校验前置条件
     *
     * @param ticket ticket
     * @return java.lang.String
     * @author rongying
     * @date 2021/8/5 11:34
     */
    @Override
    public String checkSaveCmdBefore(Ticket ticket) {
        if (ValidatorUtil.isEmpty(ticket)) {
            return "";
        }
        //外部状态已锁定
        if (ValidatorUtil.isNotEmpty(ticket.getTicketStatus()) && ExtStatusEnum.BEEN_SUBMITTED.getCode().toString().equals(ticket.getTicketStatus())) {
            return "该发票已锁定，不可修改";
        }
        return "";
    }

}