package com.xforceplus.elephant.image.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.rabbitmq.client.Channel;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.rabbitmq.BaseRabbitmqListener;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.elephant.image.core.business.application.collect.task.domain.FileTransformTypeConfig;
import com.xforceplus.elephant.image.core.business.consts.Constants;
import com.xforceplus.elephant.image.core.business.enums.FileTypeEnum;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.business.util.LogUtil;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.imagefile.ImageFileService;
import com.xforceplus.elephant.image.core.facade.application.collect.bill.BillFacade;
import com.xforceplus.elephant.image.core.facade.application.collect.upload.UploadFacade;
import com.xforceplus.elephant.image.core.repository.model.BatchTaskEntity;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.SettlementType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ImageFile;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.Date;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@RequiredArgsConstructor
public class InsertBillUploadSyncListener extends BaseRabbitmqListener {

    private final ContextService contextService;
    private final BatchService batchService;
    private final ImageFileService imageFileService;
    private final UploadFacade uploadFacade;
    private final BaseBillService baseBillService;
    private final BillFacade billFacade;

    @RabbitListener(bindings = @QueueBinding(value = @Queue(value = MQEnum.INSERT_BILL_UPLOAD_SYNC_QUEUE), exchange = @Exchange(value = MQEnum.DIRECT_EXCHANGE),
        key = MQEnum.INSERT_BILL_UPLOAD_SYNC_QUEUE))
    @Override
    public void onMessage(Message message, Channel channel) throws Exception {
        final Long batchNo = MapUtils.getLong(message.getMessageProperties().getHeaders(), "batchNo");
        final Long asyncTaskId = MapUtils.getLong(message.getMessageProperties().getHeaders(), Constants.ASYNC_TASK_ID);
        final UserDto userDto = JSON.parseObject(StringHelp.safeToString(message.getMessageProperties().getHeaders().get("userInfo")), UserDto.class);
        try {
            contextService.set(ContextKeys.StringKeys.TENANTID_KEY, String.valueOf(userDto.getTenantId()));
            contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, userDto.getTenantCode());
            contextService.set(ContextKeys.LongKeys.ID, userDto.getId());
            contextService.set(ContextKeys.StringKeys.USER_DISPLAYNAME, userDto.getUsername());
            if (batchNo != null) {
                final BatchTaskEntity update = new BatchTaskEntity();
                update.setId(batchNo);
                update.setUpdateTime(new Date());
                update.setBatchStatus(BatchTaskEntity.STATUS_DOING);
                batchService.update(update);
            }
            final FileTransformTypeConfig fileTransformTypeConfig = imageFileService.getFileTransformTypeConfig(userDto.getTenantId());
            final JSONObject body = JSONObject.parseObject(new String(message.getBody()));
            final BaseBill bill = body.getObject("bill", BaseBill.class);
            LogUtil.attachBillCode(bill.getBillCode());
            LogUtil.attachBacklogMills(System.currentTimeMillis() - MapUtils.getLong(message.getMessageProperties().getHeaders(), Constants.START_TIME));

            boolean isFinishTask = true;
            final JSONArray requestDtos = body.getJSONArray("images");
            for (int i = 0; i < requestDtos.size(); i++) {
                final JSONObject dto = requestDtos.getJSONObject(i);
                final Image image = dto.getObject("image", Image.class);
                final ImageFile imageFile = dto.getObject("imageFile", ImageFile.class);
                uploadFacade.executeUpload(bill, imageFile.getFileSuffix(), image, imageFile, fileTransformTypeConfig);

                final FileTypeEnum fileTypeEnum = FileTypeEnum.fromCode(imageFile.getFileSuffix());
                //需要转换或者需要识别，说明这次任务没有完成
                if (!isFinishTask) {
                    continue;
                }
                isFinishTask = (!fileTypeEnum.isTransform() && YesNo._0.getCode().equals(image.getRequireOcrFlag()));
                //isFinishTask = !((fileTypeEnum.isTransform()) || (!fileTypeEnum.isTransform() && YesNo._0.getCode().equals(image.getRequireOcrFlag())));
            }

            //AR单重算单据
            if (SettlementType.AR.getCode().equals(bill.getSettlementType())) {
                uploadFacade.reCheckBill(userDto.getTenantId(), userDto.getTenantCode(), bill.getBillCode(), "AR单上传重算单据");
            }

            //上传成功，则修改单据状态为待处理
            if (BillDataStatus.fromCode(bill.getBillDataStatus()) == BillDataStatus._6) {
                final JSONObject update = new JSONObject();
                update.put(EntityMeta.BaseBill.BILL_DATA_STATUS.code(), BillDataStatus._0.getCode());
                baseBillService.updateByBillIdSelective(bill.getId(), update);
            }

            if (asyncTaskId != null) {
                batchService.finishAsyncTask(userDto.getTenantCode(), asyncTaskId);
            }
            if (isFinishTask) {
                batchService.incrAndGetFinish(userDto.getId(), batchNo.toString());
            }
        } catch (Exception e) {
            log.error("单据补扫异常", e);
            throw new ElephantException(e);
        } finally {
            contextService.clear();
        }
    }

}
