package com.xforceplus.elephant.image.servicehandler;

import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.business.enums.RelEnum;
import com.xforceplus.elephant.image.core.util.CommonEntityServiceHandler;
import com.xforceplus.elephant.image.core.util.RequestParser;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class BackLogHandler extends CommonEntityServiceHandler {

    @QueryHandler(condition = "msg.getMetaData().get('code').equals('backLog')")
    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(final ConditionSearchCmd cmd) {
        final RequestParser requestParser = RequestParser.parse(cmd.getConditionQueryRequest());
        final List<String> values = requestParser.subValue(RelEnum.BACKLOG_ORGINFO.getRel(), EntityMeta.BackLog.ID.code());
        //区域查询
        if (ValidatorUtil.isNotEmpty(values)) {
            requestParser.removeSubField(RelEnum.BACKLOG_ORGINFO.getRel(), EntityMeta.BackLog.ID.code());
            requestParser.field(EntityMeta.BackLog.AREA_ID.code(), ConditionOp.in, values);
        }
        return super.conditionSearch(cmd);
    }

}
