package com.xforceplus.elephant.image.servicehandler;

import com.alibaba.fastjson.JSON;
import com.xforceplus.elephant.basecommon.dispatch.BeanDispatcher;
import com.xforceplus.elephant.image.core.util.CommonEntityServiceHandler;
import com.xforceplus.elephant.image.servicehandler.newbasebill.DefaultNewBaseBillService;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@RequiredArgsConstructor
@Service
public class NewBaseBillService extends CommonEntityServiceHandler {

    private final BeanDispatcher beanDispatcher;

    @QueryHandler(condition = "msg.getMetaData().get('codes').contains('baseBill')")
    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        final IAuthorizedUser user = UserInfoHolder.get();// 获取登录用户上下文
        if (null == user) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final boolean flag = beanDispatcher.dispatch(user.getTenantId(), DefaultNewBaseBillService.class)
            .handleConditionSearch(user, cmd.getPageCode(), cmd.getConditionQueryRequest());
        if (!flag) {
            return Either.right(new Tuple2<>(0, new ArrayList<>()));
        }
        log.info("Bill二开查询条件:{}", JSON.toJSONString(cmd));
        return super.conditionSearch(cmd);
    }

}

