package com.xforceplus.elephant.image.controller.batch.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.core.business.application.collect.batch.domain.EnableFlowContext;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@RequiredArgsConstructor
public class EnableFlowProcess extends AbstractProcess<BaseRequest, Boolean> {

    private final BatchService batchService;

    @Override
    protected CommonResponse<Boolean> process(BaseRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final EnableFlowContext context = new EnableFlowContext().setTenantId(user.getTenantId()).setUserId(user.getId());
        return CommonResponse.ok("成功", batchService.enable(context));
    }

}
