package com.xforceplus.elephant.image.controller.batchnumberrule.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.GetBatchNumberRuleRequest;
import com.xforceplus.elephant.image.core.facade.application.calculate.batchnumberrule.BatchNumberRuleFacade;
import com.xforceplus.elephant.image.core.repository.model.BatchNumberRuleEntity;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.validation.ValidationException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class GetBatchNumberRuleProcess extends AbstractProcess<GetBatchNumberRuleRequest, BatchNumberRuleEntity> {

    @Autowired
    private BatchNumberRuleFacade batchNumberRuleFacade;

    @Override
    protected void check(GetBatchNumberRuleRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getRuleCode(), "规则编号不能为空!");
    }

    @Override
    protected CommonResponse<BatchNumberRuleEntity> process(GetBatchNumberRuleRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final BatchNumberRuleEntity batchNumberRuleEntity = batchNumberRuleFacade.selectByCode(request.getRuleCode(), authorizedUser.getTenantId());
        return CommonResponse.ok("成功", batchNumberRuleEntity);
    }

}
