package com.xforceplus.elephant.image.controller.billdata.process.commit;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BaseBillCommitRequest;
import com.xforceplus.elephant.image.client.model.EntityObj;
import com.xforceplus.elephant.image.core.facade.application.calculate.commit.BillCommitFacade;
import com.xforceplus.elephant.image.core.facade.dto.commit.BillCommitDto;
import com.xforceplus.elephant.image.core.facade.dto.commit.BillCommitResponseDto;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class BillDataCommitProcess extends AbstractProcess<BaseBillCommitRequest, JSONObject> {

    @Autowired
    private BillCommitFacade billCommitFacade;

    @Override
    protected void check(BaseBillCommitRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getEntities(), "entities不能为空");
    }

    @Override
    protected CommonResponse<JSONObject> process(BaseBillCommitRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final List<String> billCodes = request.getEntities().stream().map(EntityObj::getBillCode).collect(Collectors.toList());
        if (ValidatorUtil.isEmpty(billCodes)) {
            return CommonResponse.failed("单号不存在");
        }
        //单据提交
        final BillCommitResponseDto responseDto = billCommitFacade.commitBill(BillCommitDto.builder()
            .billCodeList(billCodes)
            .type(request.getType())
            .backRemark(request.getBackRemark())
            .commitRemark(request.getCommitRemark())
            .tenantId(authorizedUser.getTenantId())
            .userId(authorizedUser.getId())
            .userName(authorizedUser.getUsername())
            .billEntityCode(EntityMeta.BaseBill.code())
            .imageEntityCode(EntityMeta.Image.code())
            .ticketEntityCode(EntityMeta.Ticket.code())
            .build());
        return CommonResponse.ok("成功", (JSONObject) JSONObject.toJSON(responseDto));
    }

}
