package com.xforceplus.elephant.image.controller.compare.image.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.enums.bill.ExtStatusEnum;
import com.xforceplus.elephant.basecommon.help.NameUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.pubsub.PubSubUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BackTicketRequest;
import com.xforceplus.elephant.image.core.business.application.collect.bill.service.BillService;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.service.TicketService;
import com.xforceplus.elephant.image.core.business.application.compare.bill.service.CompareBillService;
import com.xforceplus.elephant.image.core.business.application.config.common.domain.CompareScanConfig;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.AuditBackStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackFlag;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ReceiveStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Service;

@Slf4j
@Service
@RequiredArgsConstructor
public class CompareBackTicketProcess extends AbstractProcess<BackTicketRequest, Boolean> {

    private final CompareImageProcessService compareImageProcessService;
    private final TicketService ticketService;
    private final BillService billService;
    private final BillImageTicketService billImageTicketService;
    private final ExecutorService imageThreadPool;
    private final ContextService contextService;
    private final ConfigService configService;
    private final CompareBillService compareBillService;
    private final PubSubUtils pubSubUtils;

    @Override
    protected void check(BackTicketRequest request) throws ValidationException {
        super.check(request);
        if (request.isAllSelected()) {
            checkEmpty(request.getBillCode(), "billCode参数不能为空");
        }
        if (!request.isAllSelected()) {
            checkEmpty(request.getIncluded(), "影像id不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(BackTicketRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();// 获取登录用户上下文
        if (user == null) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        compareImageProcessService.prepareOperateData(request);
        if (CollectionUtils.isEmpty(request.getIds())) {
            return CommonResponse.failed("没有符合条件的数据");
        }
        final BaseBill baseBill = billService.selectBaseBillByCode(user.getTenantId(), request.getBillCode(), EntityMeta.CompareBaseBill.code());
        if (baseBill == null) {
            throw new ValidationException("没有找到单据数据");
        }
        final List<Ticket> tickets = ticketService.selectBaseTicketByImageIds(user.getTenantId(), request.getIds(), EntityMeta.CompareTicket.code());
        if (CollectionUtils.isEmpty(tickets)) {
            return CommonResponse.failed("没有找到发票数据");
        }

        //更新单证
        final List<Long> ids = tickets.stream().map(Ticket::getId).collect(Collectors.toList());
        final Map<String, Object> ticketUpdate = new HashMap<>();
        ticketUpdate.put(EntityMeta.Ticket.AUDIT_BACK_STATUS.code(), AuditBackStatus._1.getCode());
        ticketUpdate.put(EntityMeta.Ticket.BACK_REMARK.code(), request.getBackRemark());
        ticketService.updateMulti(ids, ticketUpdate, EntityMeta.CompareTicket.code());

        //更新单据
        final Map<String, Object> billUpdate = new HashMap<>();
        billUpdate.put(EntityMeta.BaseBill.BILL_DATA_STATUS.code(), BillDataStatus._0.getCode());
        billUpdate.put(EntityMeta.BaseBill.RECEIVE_STATUS.code(), ReceiveStatus._5.getCode());
        billUpdate.put(EntityMeta.BaseBill.BACK_FLAG.code(), BackFlag._1.getCode());
        billService.updateBillByParam(baseBill.getId(), billUpdate, EntityMeta.CompareBaseBill.code());

        final Long tenantId = user.getTenantId();
        final String tenantCode = user.getTenantCode();
        final Long userId = user.getId();
        final String userName = user.getUserName();
        CompletableFuture.runAsync(() -> {
            contextService.set(ContextKeys.StringKeys.TENANTID_KEY, String.valueOf(tenantId));
            contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, tenantCode);
            contextService.set(ContextKeys.LongKeys.ID, userId);
            contextService.set(ContextKeys.StringKeys.USER_DISPLAYNAME, userName);
            try {
                //下发单据
                final List<Map> mapList = billImageTicketService.syncBillTicket(tenantId, baseBill.getBillCode(), baseBill.getBillTypeCode(), map -> {
                    final JSONObject invoiceMain = (JSONObject) MapUtils.getObject(map, "invoiceMain");
                    if (invoiceMain != null) {
                        invoiceMain.put(NameUtils.firstLowerName(EntityMeta.Ticket.BACK_TYPE.code()), BackType._1.getCode());
                        invoiceMain.put(NameUtils.firstLowerName(EntityMeta.Ticket.TICKET_STATUS.code()), Integer.toString(ExtStatusEnum.DELETE_SUCCESS.getCode()));
                    }
                });
                if (ValidatorUtil.isNotEmpty(mapList)) {
                    mapList.forEach(map -> {
                        final String description = StringHelp.safeToString(map.get("description"));
                        final String sealedMessage = StringHelp.safeToString(map.get("message"));
                        final String requestName = StringHelp.safeToString(map.get("requestName"));
                        final Map<String, String> tags = (Map<String, String>) map.get("tags");
                        pubSubUtils.sendSealedMessage(tenantId, description, requestName, tags, sealedMessage);
                    });
                }
                final CompareScanConfig compareScanConfig = Optional.ofNullable(configService.selectDictObj(tenantId, DictEnum.COMPARE_SCAN_CONFIG.getCode(), CompareScanConfig.class))
                    .orElse(new CompareScanConfig());
                if (compareScanConfig.isBizOrder()) {
                    compareBillService.deleteMainBillAndPushCompareTicket(tenantId, Arrays.asList(request.getBillCode()));
                } else {
                    compareBillService.resetAuditAndPushMainBill(tenantId, tenantCode, Arrays.asList(request.getBillCode()), userId, userName);
                }
            } catch (Exception e) {
                log.error("删除并下发主数据异常", e);
            } finally {
                contextService.clear();
            }
        }, imageThreadPool);

        return CommonResponse.ok("成功");
    }

}
