package com.xforceplus.elephant.image.controller.compare.ticket;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.RedisLockMD5;
import com.xforceplus.elephant.basecommon.process.request.BatchRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.process.response.ListResult;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.compare.CompareTicketApi;
import com.xforceplus.elephant.image.client.model.BackBaseBillRequest;
import com.xforceplus.elephant.image.client.model.ClearTicketDataRequest;
import com.xforceplus.elephant.image.client.model.DeleteBackTicketsRequest;
import com.xforceplus.elephant.image.client.model.DeleteTicketListRequest;
import com.xforceplus.elephant.image.client.model.GetBaseTicketListRequest;
import com.xforceplus.elephant.image.client.model.GetClaimTicketListRequest;
import com.xforceplus.elephant.image.client.model.GetExceAndWarnInfoRequest;
import com.xforceplus.elephant.image.client.model.GetTicketDataRequest;
import com.xforceplus.elephant.image.client.model.GetTicketDetailRequest;
import com.xforceplus.elephant.image.client.model.GetTicketManyRequest;
import com.xforceplus.elephant.image.client.model.GetTicketTypeListRequest;
import com.xforceplus.elephant.image.client.model.ReCheckTicketRequest;
import com.xforceplus.elephant.image.client.model.ReSendTicketRequest;
import com.xforceplus.elephant.image.client.model.ReVerifyRequest;
import com.xforceplus.elephant.image.client.model.SaveTicketDataRequest;
import com.xforceplus.elephant.image.client.model.SelectTicketAttachmentRequest;
import com.xforceplus.elephant.image.client.model.SendVerifyRequest;
import com.xforceplus.elephant.image.client.model.SubmitTicketRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareClearTicketDataProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareDeleteBackTicketsProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareDeletePublicTicketListProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareGetBaseTicketListProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareGetClaimTicketListProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareGetExceAndWarnInfoProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareGetInvoiceTypeListProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareGetTicketDataProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareGetTicketDetailProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareGetTicketManyProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareGetTicketTypeListProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareReCheckTicketProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareReSendTicketProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareReVerifyProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareSelectBackTicketsProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareSelectTicketAttachmentProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareSendVerifyFacadeProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.CompareSendVerifyProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.MatchBillProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.deleteperson.DefaultCompareDeletePersonTicketListProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.save.DefaultCompareSaveTicketDataProcess;
import com.xforceplus.elephant.image.controller.compare.ticket.process.submit.DefaultCompareSubmitTicketProcess;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.domain.TicketTypeConfig;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class CompareTicketController extends BaseController implements CompareTicketApi {

    @Autowired
    private CompareDeletePublicTicketListProcess deletePublicTicketListProcess;
    @Autowired
    private CompareGetTicketDetailProcess getTicketDetailProcess;
    @Autowired
    private CompareGetTicketTypeListProcess getTicketTypeListProcess;
    @Autowired
    private CompareGetTicketDataProcess getTicketDataProcess;
    @Autowired
    private CompareClearTicketDataProcess clearTicketDataProcess;
    @Autowired
    private CompareSendVerifyProcess sendVerifyProcess;
    @Autowired
    private CompareGetExceAndWarnInfoProcess getExceAndWarnInfoProcess;
    @Autowired
    private CompareGetClaimTicketListProcess getClaimTicketListProcess;
    @Autowired
    private CompareGetTicketManyProcess getTicketManyProcess;
    @Autowired
    private CompareSelectTicketAttachmentProcess selectTicketAttachmentProcess;
    @Autowired
    private CompareReSendTicketProcess reSendTicketProcess;
    @Autowired
    private CompareReCheckTicketProcess reCheckTicketProcess;
    @Autowired
    private CompareSendVerifyFacadeProcess sendVerifyFacadeProcess;
    @Autowired
    private CompareReVerifyProcess reVerifyProcess;
    @Autowired
    private CompareGetInvoiceTypeListProcess getInvoiceTypeListProcess;
    @Autowired
    private CompareGetBaseTicketListProcess getBaseTicketListProcess;
    @Autowired
    private MatchBillProcess matchBillProcess;
    @Autowired
    private CompareSelectBackTicketsProcess selectBackTicketsProcess;
    @Autowired
    private CompareDeleteBackTicketsProcess deleteBackTicketsProcess;

    @RedisLockMD5()
    @Override
    public CommonResponse deletePersonTicketList(@RequestBody DeleteTicketListRequest request) {
        return process(DefaultCompareDeletePersonTicketListProcess.class).execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse deletePublicTicketList(@RequestBody DeleteTicketListRequest request) {
        return deletePublicTicketListProcess.execute(request);
    }

    @Override
    public CommonResponse<JSONObject> getTicketDetail(GetTicketDetailRequest request) {
        return getTicketDetailProcess.execute(request);
    }

    @Override
    public CommonResponse getTicketMany(@RequestBody GetTicketManyRequest request) {
        return getTicketManyProcess.execute(request);
    }

    @Override
    public CommonResponse<List<TicketTypeConfig>> getTicketTypeList(GetTicketTypeListRequest request) {
        return getTicketTypeListProcess.execute(request);
    }

    @Override
    public CommonResponse<Map<String, Object>> getTicketData(GetTicketDataRequest request) {
        return getTicketDataProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse clearTicketData(@RequestBody ClearTicketDataRequest request) {
        return clearTicketDataProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse sendVerify(@RequestBody SendVerifyRequest request) {
        return sendVerifyFacadeProcess.execute(request);
    }

    @Override
    public CommonResponse<List<String>> getExceAndWarnInfo(GetExceAndWarnInfoRequest request) {
        return getExceAndWarnInfoProcess.execute(request);
    }

    @Override
    public CommonResponse<ListResult<JSONObject>> getClaimTicketList(GetClaimTicketListRequest request) {
        return getClaimTicketListProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse saveTicketData(@RequestBody SaveTicketDataRequest request) {
        return process(DefaultCompareSaveTicketDataProcess.class).execute(request);
    }

    @Override
    public CommonResponse selectTicketAttachment(SelectTicketAttachmentRequest request) {
        return selectTicketAttachmentProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse submitTicket(@RequestBody SubmitTicketRequest request) {
        return process(DefaultCompareSubmitTicketProcess.class).execute(request);
    }

    @Override
    public CommonResponse reCheckTicket(@RequestBody ReCheckTicketRequest request) {
        return reCheckTicketProcess.execute(request);
    }

    @Override
    public CommonResponse reSendTicket(@RequestBody ReSendTicketRequest request) {
        return reSendTicketProcess.execute(request);
    }

    @Override
    public CommonResponse reVerify(@Valid ReVerifyRequest request) {
        return reVerifyProcess.execute(request);
    }

    @Override
    public CommonResponse getInvoiceTypeList(@Valid GetTicketTypeListRequest request) {
        return getInvoiceTypeListProcess.execute(request);
    }

    @Override
    public CommonResponse getBaseTicketList(@Valid GetBaseTicketListRequest request) {
        return getBaseTicketListProcess.execute(request);
    }

    @Override
    public CommonResponse matchBill(@RequestBody BatchRequest request) {
        return matchBillProcess.execute(request);
    }

    @ApiOperation("查询退回发票")
    @PostMapping("/compare/ticket/selectBackTickets")
    public CommonResponse selectBackTickets(@RequestBody BackBaseBillRequest request) {
        return selectBackTicketsProcess.execute(request);
    }

    @ApiOperation("删除退回发票")
    @DeleteMapping("/compare/ticket/deleteBackTickets")
    public CommonResponse deleteBackTickets(@RequestBody DeleteBackTicketsRequest request) {
        return deleteBackTicketsProcess.execute(request);
    }

}