package com.xforceplus.elephant.image.controller.compare.ticket.process.save;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.baseconst.ConfigConstants;
import com.xforceplus.elephant.basecommon.baseconst.Constants;
import com.xforceplus.elephant.basecommon.baseconst.ReleationConstants;
import com.xforceplus.elephant.basecommon.enums.bill.OperateEnum;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.SaveTicketDataRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.domain.common.TicketSupport;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.domain.compare.ticket.CompareTicketService;
import com.xforceplus.elephant.image.core.domain.config.ConfigDictionaryService;
import com.xforceplus.elephant.image.core.domain.config.bean.ConfigDictionaryItem;
import com.xforceplus.elephant.image.core.domain.imagefile.ImageFileService;
import com.xforceplus.elephant.image.core.domain.ticket.BillTicketRelationService;
import com.xforceplus.elephant.image.core.domain.ticket.BillTicketReuseService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CheckStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CommitStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.InvoiceType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BillTicketRelation;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BillTicketReuse;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ImageFile;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Dispatch(tenantCode = "seazen")
@Service
public class SEAZENCompareSaveTicketDataProcess extends DefaultCompareSaveTicketDataProcess {

    @Autowired
    private CompareTicketService ticketService;
    @Autowired
    private CompareBaseBillService baseBillService;
    @Autowired
    private CompareImageService imageService;
    @Autowired
    private ConfigDictionaryService configDictionaryService;
    @Autowired
    private CompareBillImageTicketService billImageTicketService;
    @Autowired
    private TicketSupport ticketSupport;
    @Autowired
    private MQUtils rabbitmqUtils;
    @Autowired
    private BillTicketRelationService billTicketRelationService;
    @Autowired
    private BillTicketReuseService billTicketReuseService;
    @Autowired
    private ImageFileService imageFileService;
    @Autowired
    private TicketFacade ticketFacade;

    @Override
    protected void check(SaveTicketDataRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getOperateType())) {
            throw new ValidationException("操作类型【operateType】不能为空");
        }
        if (!Constants.NUMBER_ZERO.equals(request.getOperateType()) && !Constants.NUMBER_ONE.equals(request.getOperateType())) {
            throw new ValidationException("操作类型【operateType】传参有误：1-新增,0-修改");
        }
        if (Constants.NUMBER_ZERO.equals(request.getOperateType())) {
            if (ValidatorUtil.isEmpty(request.getParTicketId())) {
                throw new ValidationException("父单证ID【parTicketId】不能为空");
            }
            if (ValidatorUtil.isEmpty(request.getSubTicketId())) {
                throw new ValidationException("子单证ID【subTicketId】不能为空");
            }
        }
        if (Constants.NUMBER_ONE.equals(request.getOperateType())) {
            if (ValidatorUtil.isEmpty(request.getImageId())) {
                throw new ValidationException("影像ID【imageId】不能为空");
            }
        }
        if (ValidatorUtil.isEmpty(request.getTicketCode())) {
            throw new ValidationException("单证code【ticketCode】不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(SaveTicketDataRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        int count = 0;
        Long preTicketId = request.getParTicketId();
        Long subTicketId = request.getSubTicketId();
        Long imageId = null;
        boolean isUpdateType = false;//没有修改单证类型
        boolean isUpdateInvoiceType = false;//没有修改发票类型
        String origTicketCode = "";
        String repeatTag = "";
        String reuseTag = "";
        String oldInvoiceType = "";
        try {
            JSONObject jsonObject = new JSONObject();
            if (!StringHelp.safeIsEmpty(request.getFormData())) {
                jsonObject = JSONObject.parseObject(request.getFormData());
            }
            jsonObject = setUserInfo(authorizedUser, request, jsonObject);
            final Image image = imageService.selectOne(authorizedUser.getTenantId(), jsonObject.getLong(EntityMeta.Ticket.IMAGE_ID.code()));
            if (null == image) {
                return CommonResponse.failed("影像数据不存在.");
            }
            final ImageFile imageFile = image.getFileId() != null && image.getFileId() > 0 ? imageFileService.selectOne(image.getFileId()) : null;
            if (Constants.NUMBER_ZERO.equals(request.getOperateType())) {
                final Ticket ticket = ticketService.selectBaseTicketById(request.getParTicketId());
                if (null == ticket) {
                    return CommonResponse.failed("没有找到原单证数据.");
                }
                final Map<String, Object> sourceTicketMap = ticketService.selectByTicketCode(ticket.getTicketCode(), subTicketId);
                if (ValidatorUtil.isNotEmpty(sourceTicketMap)) {
                    oldInvoiceType = String.valueOf(sourceTicketMap.get("invoice_type"));
                }
                //如果修改了invoice_type 则需要重置验真状态
                if (!oldInvoiceType.equals(JSONObject.parseObject(request.getFormData()).getString("invoice_type"))) {
                    isUpdateInvoiceType = true;
                }
                if (YesNo._0.getCode().equals(ticket.getIsPublic())) {
                    final JSONObject checkJson = new JSONObject();
                    checkJson.putAll(new JSONObject(ticket.toOQSMap()));
                    if (!StringHelp.safeIsEmpty(request.getFormData())) {
                        checkJson.putAll(JSONObject.parseObject(request.getFormData()));
                    }
                    final String repeatInfo = billImageTicketService.checkTicketRepeat(ticket.getTicketCode(), ticket, checkJson, authorizedUser.getTenantId());
                    if (ValidatorUtil.isNotEmpty(repeatInfo)) {
                        return CommonResponse.failed(repeatInfo);
                    }
                }

                //校验影像是否多票，多票有结构数据不允许修改
                if (checkManyUpdate(ticket, request.getTicketCode())) {
                    return CommonResponse.failed("多票包含其他影像数据，不允许修改类型.");
                }
                if (!request.getTicketCode().equals(ticket.getTicketCode())) {
                    isUpdateType = true;//修改了单证
                    origTicketCode = ticket.getTicketCode();
                    if (!EntityMeta.CompareTicketAttachment.code().equals(request.getTicketCode())) {
                        jsonObject.put(ReleationConstants.TICKET_OTM_TICKET_ID, 0L);
                    }
                }
                jsonObject.remove("check_status");
                //判断验真状态是否重置
                checkVerifyStatus(jsonObject, request.getTicketCode(), authorizedUser.getTenantId(), subTicketId, ticket.getCheckStatus(), isUpdateType, isUpdateInvoiceType);
                processTicketSourceFile(imageFile, jsonObject);

                //没有修改单证类型
                if (!isUpdateType) {
                    try {
                        final JSONObject formData = JSONObject.parseObject(request.getFormData());
                        checkRepeatTicket(authorizedUser.getTenantId(), formData, ticket, subTicketId);
                    } catch (Exception e) {
                        logger.info("编辑后计算关系异常");
                    }
                    super.handleTicketModifyFlag(authorizedUser.getTenantId(), sourceTicketMap, jsonObject);
                    jsonObject.remove("is_repeat");
                    jsonObject.remove("repeat_tag");
                    jsonObject.remove("is_exception");
                    jsonObject.remove("exception_status");
                    jsonObject.remove("exception_info");
                    jsonObject.remove("warning_info");
                    count = ticketService.updateTicketByParam(request.getSubTicketId(), ticket.getTicketCode(), jsonObject);
                } else {
                    //删除原单证类型
                    final int num = ticketService.deleteTicketByCode(EntityMeta.CompareTicket.code(), request.getParTicketId());
                    if (num == 0) {
                        return CommonResponse.failed("原单证删除失败，请重新操作.");
                    }
                    final Long createTime = jsonObject.getLong("create_time");
                    //删除重复关系
                    clearRepeatReuse(jsonObject, request.getSubTicketId(), ticket.getTicketCode());
                    super.resetTicketAddAndChangeFlag(jsonObject);
                    jsonObject.remove("id");
                    final Long id = ticketService.insertInheritTicketByCode(request.getTicketCode(), jsonObject);
                    if (null == id) {
                        return CommonResponse.failed("单证保存失败，请检查.");
                    }
                    preTicketId = id;
                    subTicketId = id;
                    count = id > 0L ? 1 : 0;
                    if (count > 0) {
                        final Map<String, Object> updateMap = Maps.newHashMap();
                        updateMap.put("create_time", createTime);
                        updateMap.put("scan_time", createTime);
                        ticketService.updateTicketByParam(preTicketId, EntityMeta.CompareTicket.code(), updateMap);
                    }
                }
                imageId = ticket.getImageId();
                repeatTag = ticket.getRepeatTag();
                reuseTag = ticket.getReuseTag();
            }
            //新增
            if (Constants.NUMBER_ONE.equals(request.getOperateType())) {
                jsonObject.put("is_public", image.getIsPublic());
                jsonObject.put("batch_no", image.getBatchNo());
                if (null != request.getBillCode()) {
                    final BaseBill billEntity = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(), request.getBillCode());
                    if (null == billEntity) {
                        return CommonResponse.failed("新增单据数据不存在，无法挂接.");
                    }
                    jsonObject.put("bill_code", billEntity.getBillCode());
                    jsonObject.put("is_hooked", YesNo._1.getCode());
                    jsonObject.put(EntityMeta.Ticket.HOOK_TIME.code(), System.currentTimeMillis());
                    jsonObject.put(EntityMeta.Ticket.BILL_SYSTEM_SOURCE.code(), billEntity.getSystemOrig());
                    jsonObject.put(EntityMeta.Ticket.BILL_O_T_M_TICKET_ID.code(), billEntity.getId());
                    super.handleManyTicketAddFlag(billEntity, jsonObject);
                    //扫描待办 isPublic=2, 上传的发票默认已提交
                    if (ValidatorUtil.isNotEmpty(image.getIsPublic()) && image.getIsPublic().equals(2)) {
                        jsonObject.put(EntityMeta.Ticket.COMMIT_STATUS.code(), CommitStatus._1.getCode());
                    }
                }
                //判断验真状态
                checkVerifyStatus(jsonObject, request.getTicketCode(), authorizedUser.getTenantId(), null, null, true, isUpdateInvoiceType);
                jsonObject.remove("id");
                final Long id = ticketService.insertInheritTicketByCode(request.getTicketCode(), jsonObject);
                if (null == id) {
                    return CommonResponse.failed("单证保存失败，请检查.");
                }
                preTicketId = id;
                subTicketId = id;
                count = id > 0L ? 1 : 0;
                imageId = request.getImageId();
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return CommonResponse.failed("保存异常：" + e.getMessage());
        }
        if (count > 0) {
            //发起验签
            final Map<String, Object> entityMap = ticketService.selectByTicketCode(request.getTicketCode(), subTicketId);
            ticketFacade.pdfVerify(entityMap);
            //是否自动发验真
            isSendVerify(subTicketId, request.getTicketCode(), authorizedUser);
            //校验影像类型，改字
            updateCheckBillImage(authorizedUser.getTenantId(), request.getBillCode(), imageId, request.getTicketCode(), origTicketCode, isUpdateType, preTicketId);
            checkOtherTicket(repeatTag, reuseTag);
            if (imageId != null) {
                billImageTicketService.updateManyExceWarnData(imageId);
                //修改影像
                billImageTicketService.updateImageExceWarnData(authorizedUser.getTenantId(), imageId);
            }
            billImageTicketService.updateRecogBillInfo(authorizedUser.getTenantId(), request.getBillCode());
            if (StringHelp.safeIsEmpty(request.getBillCode())) {
                //发送mq,校验单证异常预警信息
                final Map<String, Object> paramMap = Maps.newHashMap();
                paramMap.put("ticketId", subTicketId);
                paramMap.put("ticketCode", request.getTicketCode());
                paramMap.put("source", "编辑单证保存后重算单证");
                final Map<String, Object> headers = new HashMap<>();
                headers.put(TENANT_CODE, authorizedUser.getTenantCode());
                rabbitmqUtils.sendByDirectExchange(MQEnum.COMPARE_CHECK_TICKET_EXCE_WARN_QUEUE, paramMap, headers);
            }
            return CommonResponse.ok("保存成功", true);
        } else {
            return CommonResponse.failed("无记录保存成功");
        }
    }

    /**
     * 修改的是多票，有其他数据结构不让修改
     *
     * @param entity 对象
     * @return
     */
    private boolean checkManyUpdate(Ticket entity, String updateTicketCode) {
        if (EntityMeta.CompareTicketMany.code().equals(entity.getTicketCode()) && !EntityMeta.CompareTicketMany.code().equals(updateTicketCode)) {
            final List<Ticket> entityList = ticketService.selectBaseTicketByImageID(entity.getImageId());
            if (!CollectionUtils.isEmpty(entityList) && entityList.size() > 1) {
                return true;
            }
        }
        return false;
    }

    /**
     * 设置用户信息
     *
     * @param authorizedUser 用户
     * @param request        请求
     * @param jsonObject     json对象
     * @return
     */
    private JSONObject setUserInfo(IAuthorizedUser authorizedUser, SaveTicketDataRequest request, JSONObject jsonObject) {
        jsonObject.put("ticket_code", request.getTicketCode());
        if (Constants.NUMBER_ZERO.equals(request.getOperateType())) {
            jsonObject.put("update_time", System.currentTimeMillis());
            jsonObject.put("update_user_id", authorizedUser.getId());
            jsonObject.put("update_user_name", authorizedUser.getUsername());
        } else {
            final long ccurrentTime = System.currentTimeMillis();
            jsonObject.put("create_time", ccurrentTime);
            jsonObject.put("create_user_id", authorizedUser.getId());
            jsonObject.put("create_user_name", authorizedUser.getUsername());
            jsonObject.put("scan_user_id", authorizedUser.getId());
            jsonObject.put("scan_user_name", authorizedUser.getUsername());
            jsonObject.put("scan_time", ccurrentTime);
            jsonObject.put("tenant_id", authorizedUser.getTenantId());
            jsonObject.put("image_id", request.getImageId());
            if (null != request.getXPoint()) {
                jsonObject.put("x_point", request.getXPoint());
            }
            if (null != request.getYPoint()) {
                jsonObject.put("y_point", request.getYPoint());
            }
            if (null != request.getWidth()) {
                jsonObject.put("width", request.getWidth());
            }
            if (null != request.getHeight()) {
                jsonObject.put("height", request.getHeight());
            }
        }
        if (ValidatorUtil.isNotEmpty(request.getLabelIdList())) {
            jsonObject.put(ReleationConstants.SYSTEM_LABEL_ID, request.getLabelIdList().stream().map(r -> r.toString()).collect(Collectors.joining(",")));
        } else {
            jsonObject.put(ReleationConstants.SYSTEM_LABEL_ID, "");
        }
        //获取公司编号
        getCompanyNo(authorizedUser.getTenantId(), request.getTicketCode(), jsonObject);
        //设置发票类型值
        super.handleInvoiceType(request, jsonObject);
        //附件移除发票7要素
        super.removeField(request.getTicketCode(), jsonObject);
        //全电发票 发票代码设置为"全电发票"
        final String invoiceType = jsonObject.getString(EntityMeta.Ticket.INVOICE_TYPE.code());
        if (Arrays.asList(InvoiceType.QC.getCode(), InvoiceType.QS.getCode(), InvoiceType.QV.getCode()).contains(invoiceType)) {
            jsonObject.put(EntityMeta.Ticket.INVOICE_CODE.code(), com.xforceplus.elephant.image.core.business.consts.Constants.ALL_ELECTRIC_INVOICE_CODE);
        }
        return jsonObject;
    }

    /**
     * 单据已退回，修改影像，添加改字标记
     *
     * @param billCode 业务单号
     * @param imageId  影像ID
     */
    private void updateCheckBillImage(Long tenantId, String billCode, Long imageId, String ticketCode, String origTicketCode, boolean isUpdateType, Long preTicketId) {
        if (null == imageId) {
            return;
        }
        final JSONObject update = new JSONObject();
        //修改结构数据类型，影像类型同步修改
        final boolean isLevel = ticketSupport.updateImageTypeWhenAttach(update, isUpdateType, ticketCode, origTicketCode);
        //影像退字标记去掉
        super.checkImageModify(tenantId, imageId, update);
        if (update.size() > 0) {
            update.put("id", imageId);
            final boolean success = imageService.updateImageSelective(JSONObject.parseObject(update.toString(), Image.class));
            if (success && isLevel && !StringHelp.safeIsEmpty(billCode)) {
                //重算层级
                billImageTicketService.resetLevel(tenantId, billCode);
            } else {
                //校验重复复用
                billImageTicketService.checkTicketRepeatAndReuse(tenantId, preTicketId, OperateEnum.HOOK, billCode);
            }
            return;
        }

        //校验重复复用
        billImageTicketService.checkTicketRepeatAndReuse(tenantId, preTicketId, OperateEnum.HOOK, billCode);

    }

    /**
     * 检查验真状态
     *
     * @param orgEntity  orgEntity
     * @param ticketCode 单证代码
     * @param tenantId   租户ID
     * @param ticketId   单证ID
     */
    private void checkVerifyStatus(JSONObject orgEntity, String ticketCode, Long tenantId, Long ticketId, String checkStatus, boolean isUpdateType, boolean isUpdateInvoiceType) {
        //字典
        Map<String, ConfigDictionaryItem> dictionaryMap = Maps.newHashMap();
        final List<ConfigDictionaryItem> dictionaryItemList = configDictionaryService.selectItems(tenantId, ConfigConstants.CONFIG_DICT_CODE_TICKET_CHEKCT_CONTENT);
        if (!CollectionUtils.isEmpty(dictionaryItemList)) {
            dictionaryMap = dictionaryItemList.stream().collect(Collectors.toMap(ConfigDictionaryItem::getItemCode, a -> a, (k1, k2) -> k1));
        }
        final String newTicketCode = orgEntity.getString(EntityMeta.Ticket.INVOICE_TYPE.code());
        final ConfigDictionaryItem dictionaryItem = dictionaryMap.get(newTicketCode);
        if (null == dictionaryItem) {
            setVerifyField(orgEntity, CheckStatus._4.getCode(), "当前单证类型不支持验真.");
            return;
        }
        //没有修改类型
        if (!isUpdateType && !isUpdateInvoiceType) {
            //原验真状态是无需验真，直接返回
            if (ValidatorUtil.isNotEmpty(checkStatus) && CheckStatus._4.getCode().equals(checkStatus)) {
                return;
            }
            final JSONArray jsonArray = JSONArray.parseArray(dictionaryItem.getVerifyFields());
            if (null == jsonArray || jsonArray.size() < 0) {
                return;
            }
            //校验验真要素字段你是否修改
            final Map<String, Object> entityMap = ticketService.selectByTicketCode(ticketCode, ticketId);
            if (null == entityMap) {
                return;
            }
            int count = 0;
            for (int i = 0; i < jsonArray.size(); i++) {
                final JSONObject object = jsonArray.getJSONObject(i);
                final String field = object.getString("orgField");
                if (ValidatorUtil.isNotEmpty(orgEntity.getString(field)) && !orgEntity.getString(field).equals(entityMap.get(field))) {
                    count++;
                } else if (ValidatorUtil.isNotEmpty(entityMap.get(field)) && !entityMap.get(field).toString().equals(orgEntity.getString(field))) {
                    count++;
                }
            }
            if (count == 0) {
                return;
            }
            setVerifyField(orgEntity, CheckStatus._0.getCode(), "");
            return;
        }
        //类型变更：校验是否开启验真
        if (!dictionaryItem.isCheckVerify()) {
            setVerifyField(orgEntity, CheckStatus._4.getCode(), "当前单证类型不支持验真.");
            return;
        }
        //获取验真表达式（小开关）是否需要验真
        if (ValidatorUtil.isNotEmpty(dictionaryItem.getVerifyExpression())) {
            final ExpressionParser parser = new SpelExpressionParser();
            final EvaluationContext context = new StandardEvaluationContext();
            context.setVariable("obj", orgEntity);
            context.setVariable("details", super.getInvoiceDetailList(ticketId, ticketCode));
            final boolean verifyExpression = parser.parseExpression(dictionaryItem.getVerifyExpression()).getValue(context, Boolean.class);
            if (!verifyExpression) {
                setVerifyField(orgEntity, CheckStatus._4.getCode(), "当前单证类型不支持验真.");
                return;
            }
        }
        final JSONArray jsonArray = JSONArray.parseArray(dictionaryItem.getVerifyFields());
        if (null == jsonArray || jsonArray.size() < 0) {
            setVerifyField(orgEntity, CheckStatus._4.getCode(), "当前单证类型不支持验真.");
            return;
        }
        //类型变更后且有可验真字段，则重置验真状态，由客户发起重新验真
        setVerifyField(orgEntity, CheckStatus._0.getCode(), "");
        return;
    }

    /**
     * 重置验真状态
     *
     * @param orgEntity   orgEntity
     * @param checkStatus checkStatus
     * @param remark      remark
     */
    private void setVerifyField(JSONObject orgEntity, String checkStatus, String remark) {
        orgEntity.put("check_status", checkStatus);
        orgEntity.put("check_remark", remark);
        orgEntity.put("check_task_id", "");
        orgEntity.put("check_user_id", 0L);
        orgEntity.put("check_user_name", "");
    }

    /**
     * 清空重复，复用字段
     *
     * @param jsonObject json对象
     * @param ticketId   单证ID
     * @param ticketCode 单证代码
     */
    private void clearRepeatReuse(JSONObject jsonObject, Long ticketId, String ticketCode) {
        //删除重复关系
        billTicketRelationService.deleteBillTicketRelation(ticketId, ticketCode);
        billTicketReuseService.deleteBillTicketReuse(ticketId, ticketCode);
        jsonObject.put("is_repeat", YesNo._0.getCode());
        jsonObject.put("repeat_tag", "");
        jsonObject.put("is_reuse", YesNo._0.getCode());
        jsonObject.put("reuse_tag", "");
    }

    /**
     * 重算其他单证
     *
     * @param repeatTag repeatTag
     * @param reuseTag  reuseTag
     */
    private void checkOtherTicket(String repeatTag, String reuseTag) {
        if (!StringHelp.safeIsEmpty(repeatTag)) {
            final List<BillTicketRelation> relationEntityList = billTicketRelationService.selectBillTicketRelation(repeatTag);
            if (!CollectionUtils.isEmpty(relationEntityList)) {
                if (relationEntityList.size() == 1) {
                    billTicketRelationService.deleteBillTicketRelation(relationEntityList.get(0).getTicketId(), relationEntityList.get(0).getTicketCode());
                    final Map<String, Object> update = Maps.newHashMap();
                    update.put("is_repeat", YesNo._0.getCode());
                    update.put("repeat_tag", "");
                    ticketService.updateTicketByParam(relationEntityList.get(0).getTicketId(), relationEntityList.get(0).getTicketCode(), update);
                }
                relationEntityList.forEach(r -> billImageTicketService.sendTicketMq(r.getTenantCode(), r.getTicketId(), r.getTicketCode(), "编辑单证保存后重算其他单证重复"));
            }
        }
        if (!StringHelp.safeIsEmpty(reuseTag)) {
            final List<BillTicketReuse> reuseEntities = billTicketReuseService.selectBillTicketReuse(reuseTag);
            if (!CollectionUtils.isEmpty(reuseEntities)) {
                if (reuseEntities.size() == 1) {
                    billTicketReuseService.deleteBillTicketReuse(reuseEntities.get(0).getTicketId(), reuseEntities.get(0).getTicketCode());
                    final Map<String, Object> update = Maps.newHashMap();
                    update.put("is_reuse", YesNo._0.getCode());
                    update.put("reuse_tag", "");
                    ticketService.updateTicketByParam(reuseEntities.get(0).getTicketId(), reuseEntities.get(0).getTicketCode(), update);
                }
                reuseEntities.forEach(r -> billImageTicketService.sendTicketMq(r.getTenantCode(), r.getTicketId(), r.getTicketCode(), "编辑单证保存后重算其他单证复用"));
            }
        }
    }

    /**
     * 是否自动发验真
     */
    @Override
    protected void isSendVerify(Long ticketId, String ticketCode, IAuthorizedUser authorizedUser) {
        return;
    }

    /**
     * 获取公司编号
     */
    @Override
    protected void getCompanyNo(Long tenantId, String ticketCode, JSONObject jsonObject) {
        return;
    }

    /**
     * 编辑变更发票号码,代码,联次 若is_repeat则重算关系(不变更单证类型)
     *
     * @param formData     formData
     * @param ticket ticket
     * @param subTicketId  subTicketId
     */
    @Override
    protected void checkRepeatTicket(Long tenantId, JSONObject formData, Ticket ticket, Long subTicketId) {
        //不重复则不计算关系
        if (!YesNo._1.getCode().equals(ticket.getIsRepeat())) {
            return;
        }
        final Map<String, Object> sourceTicket = ticketService.selectByTicketCode(ticket.getTicketCode(), subTicketId);
        if (ValidatorUtil.isEmpty(sourceTicket)) {
            return;
        }
        if (!formData.getString("invoice_no").equals(StringHelp.safeToString(ticket.getInvoiceNo()))
            || !formData.getString("invoice_code").equals(StringHelp.safeToString(ticket.getInvoiceCode()))) {
            billImageTicketService.checkTicketRepeatAndReuse(tenantId, Arrays.asList(ticket.getImageId()), OperateEnum.DELETE, ticket.getBillCode());
            billImageTicketService.updateRecogBillInfo(tenantId, ticket.getBillCode());
        }

    }

}