package com.xforceplus.elephant.image.controller.image.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.baseconst.ReleationConstants;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.client.model.SaveImageRequest;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.facade.application.collect.bill.BillFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ExceptionStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageCategory;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaveCoverImageProcess extends AbstractProcess<SaveImageRequest, Boolean> {

    @Autowired
    private ImageService imageService;

    @Autowired
    private BillFacade billFacade;
    @Autowired
    private BillImageTicketService billImageTicketService;

    @Autowired
    private BaseBillService baseBillService;

    @Override
    protected void check(final SaveImageRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getEntities(), "封面不能为空");
        request.getEntities().forEach(dto -> {
            checkEmpty(dto.getBillCode(), "单据code不能为空");
            checkEmpty(dto.getImageSource(), "来源不能为空");
            checkEmpty(dto.getFileUrl(), "原始文件路径不能为空");
            checkEmpty(dto.getFileUrlHandle(), "处理文件路径不能为空");
            checkEmpty(dto.getFileType(), "原始文件类型不能为空");
            checkEmpty(dto.getFileTypeHandle(), "处理文件类型不能为空");
            checkEmpty(dto.getIsPublic(), "是否公共上传不能为空");
        });
    }

    @Override
    protected CommonResponse<Boolean> process(final SaveImageRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final ImageDTO newImage = request.getEntities().get(0);
        final BaseBill baseBill = billFacade.selectBaseBillByCode(authorizedUser.getTenantId(), newImage.getBillCode(), EntityMeta.BaseBill.code());
        if (null == baseBill) {
            return CommonResponse.failed("单据不存在");
        }
        final List<Long> ids = new ArrayList<>();
        request.getEntities().forEach(item -> {
            final Image entity = Image.fromOQSMap(BeanUtils.convertJSON(item));
            entity.setBatchNo(Long.toString(System.currentTimeMillis()));
            entity.setRequireOcrFlag(YesNo._0.getCode());
            entity.setImageCategory(ImageCategory._1.getCode());
            entity.setImageType(ImageType._1.getCode());
            entity.setRecStatus(RecStatus._2.getCode());
            entity.setStatus(ImageStatus._1.getCode());
            entity.setIsManualUnhook(YesNo._0.getCode());
            entity.setExceptionStatus(ExceptionStatus._0.getCode());
            entity.setReturnStatus(BackType._0.getCode());
            entity.setCreateUserId(authorizedUser.getId());
            entity.setCreateUserName(authorizedUser.getUsername());
            entity.setTenantId(authorizedUser.getTenantId());
            entity.setFileUrlLocal(StringUtils.EMPTY);
            entity.setFileOrder("0");
            entity.setIsPublic(YesNo._1.getCode());
            entity.setCreateUserCode(authorizedUser.getUserCode());
            entity.setCalculateStatus(YesNo._1.getCode());
            entity.setBillEntityCode(baseBill.getBillTypeCode());
            final JSONObject imageJson = new JSONObject(entity.toOQSMap());
            imageJson.put(ReleationConstants.BILL_OTM_IMAGE_ID, baseBill.getId());
            ids.addAll(imageService.saveForMap(Arrays.asList(imageJson)));
        });
        billImageTicketService.updateRecogBillInfo(authorizedUser.getTenantId(), baseBill.getBillCode());
        //上传成功，则修改单据状态为待处理
        if (BillDataStatus.fromCode(baseBill.getBillDataStatus()) == BillDataStatus._6) {
            final JSONObject update = new JSONObject();
            update.put(EntityMeta.BaseBill.BILL_DATA_STATUS.code(), BillDataStatus._0.getCode());
            baseBillService.updateByBillIdSelective(baseBill.getId(), update);
        }
        return CommonResponse.ok("成功", ids.size() > 0);
    }

}
