package com.xforceplus.elephant.image.controller.image.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.business.application.collect.image.domain.UploadMessageResult;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author yuhongxia
 * @description 上传拦截文案
 * @date
 */
@Service
public class UploadMessageProcess extends AbstractProcess<BaseRequest, UploadMessageResult> {

    @Autowired
    private ConfigService configService;

    @Override
    protected CommonResponse<UploadMessageResult> process(BaseRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final List<UploadMessageResult> configList = configService.selectDict(authorizedUser.getTenantId(), DictEnum.UPLOAD_MESSAGE.getCode(),
            UploadMessageResult.class);
        UploadMessageResult uploadMessageResult = new UploadMessageResult();
        if (ValidatorUtil.isNotEmpty(configList)) {
            uploadMessageResult = configList.get(0);
        }
        return CommonResponse.ok("", uploadMessageResult);
    }

}
