package com.xforceplus.elephant.image.controller.imagecopy;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.process.response.ListResult;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.ImageCopyApi;
import com.xforceplus.elephant.image.client.model.GetImageCopyListRequest;
import com.xforceplus.elephant.image.client.model.ImageCopyDTO;
import com.xforceplus.elephant.image.client.model.SaveImageCopyRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.imagecopy.process.DeleteImageCopyProcess;
import com.xforceplus.elephant.image.controller.imagecopy.process.GetImageCopyListProcess;
import com.xforceplus.elephant.image.controller.imagecopy.process.GetImageCopyStreamProcess;
import com.xforceplus.elephant.image.controller.imagecopy.process.SaveImageCopyProcess;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class ImageCopyController extends BaseController implements ImageCopyApi {

    @Autowired
    private DeleteImageCopyProcess deleteImageCopyProcess;
    @Autowired
    private GetImageCopyListProcess getImageCopyListProcess;
    @Autowired
    private SaveImageCopyProcess saveImageCopyProcess;
    @Autowired
    private GetImageCopyStreamProcess getImageCopyStreamProcess;

    @Override
    public CommonResponse<Boolean> deleteImageCopy(@PathVariable("imageCopyId") Long imageCopyId, @RequestBody BaseRequest request) {
        return deleteImageCopyProcess.execute(imageCopyId, request);
    }

    @AuthorizedDefinition(authorization = false)
    @CrossOrigin
    @Override
    public Object getImageCopyFile(@PathVariable("imageCopyId") Long imageCopyId, @PathVariable("fileExt") String fileExt, BaseRequest request) {
        return getImageCopyStreamProcess.execute(imageCopyId, request);
    }

    @Override
    public CommonResponse<ListResult<ImageCopyDTO>> getImageCopyList(GetImageCopyListRequest request) {
        return getImageCopyListProcess.execute(request);
    }

    @AuthorizedDefinition(authorization = false)
    @CrossOrigin
    @Override
    public Object getImageCopyStream(@PathVariable("imageCopyId") Long imageCopyId, BaseRequest request) {
        return getImageCopyStreamProcess.execute(imageCopyId, request);
    }

    @Override
    public CommonResponse<Long> saveImageCopy(@RequestBody SaveImageCopyRequest request) {
        return saveImageCopyProcess.execute(request);
    }

}