package com.xforceplus.elephant.image.controller.imagecopy.process;

import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.vaildate.Validator;
import com.xforceplus.elephant.image.core.business.infrastructure.port.FileService;
import com.xforceplus.elephant.image.core.domain.image.ImageCopyService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ImageCopy;
import java.io.IOException;
import java.io.InputStream;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;

@Service
public class GetImageCopyStreamProcess implements Validator {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ImageCopyService imageCopyService;
    @Autowired
    private FileService fileService;

    protected void check(Long imageCopyId, BaseRequest request) throws ValidationException {
        if (imageCopyId == null) {
            throw new ValidationException("主键不能为空");
        }
    }

    public ResponseEntity<byte[]> execute(Long imageCopyId, BaseRequest request) {
        check(imageCopyId, request);
        return process(imageCopyId, request);
    }

    protected ResponseEntity<byte[]> process(Long imageCopyId, BaseRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final ImageCopy entity = imageCopyService.selectOne(imageCopyId);
        checkEmpty(entity, "副本不存在");
        if (entity.getFileUrl().startsWith("http")) {
            try (InputStream is = HttpUtils.doGetInputStream(entity.getFileUrl())) {
                final byte[] bytes = StreamUtils.copyToByteArray(is);
                return ResponseEntity.ok()
                    //.header("Content-Disposition", "attachment;fileName=" + entity.getId() + "." + entity.getFileType())
                    .contentType(fileService.mediaType(entity.getFileType()))
                    .contentLength(bytes.length).body(bytes);
            } catch (IOException e) {
                logger.error("下载失败", e);
            }
        } else {
            try (InputStream is = fileService.getFileInputStream(user.getTenantId(), user.getId(), entity.getFileUrl())) {
                final byte[] bytes = StreamUtils.copyToByteArray(is);
                return ResponseEntity.ok()
                    //.header("Content-Disposition", "attachment;fileName=" + entity.getId() + "." + entity.getFileType())
                    .contentType(fileService.mediaType(entity.getFileType()))
                    .contentLength(bytes.length).body(bytes);
            } catch (IOException e) {
                logger.error("下载失败", e);
            }
        }
        return ResponseEntity.notFound().build();
    }

}