package com.xforceplus.elephant.image.controller.imagecopy.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.SaveImageCopyRequest;
import com.xforceplus.elephant.image.core.business.infrastructure.port.FileService;
import com.xforceplus.elephant.image.core.domain.image.ImageCopyService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ImageCopy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ValidationException;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaveImageCopyProcess extends AbstractProcess<SaveImageCopyRequest, Long> {

    @Autowired
    private ImageCopyService imageCopyService;
    @Autowired
    private FileService fileService;

    @Override
    protected void check(SaveImageCopyRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getParentImageId(), "主影像ID不能为空");
        checkEmpty(request.getImageContent(), "影像内容不能为空");
        if (!request.getImageContent().startsWith("data:image/") || request.getImageContent().split(",").length != 2) {
            throw new ValidationException("影像内容不是base64，无法解析");
        }
    }

    @Override
    protected CommonResponse<Long> process(SaveImageCopyRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        try {
            final Pattern pattern = Pattern.compile("data:image/(\\w+);base64,");
            final Matcher matcher = pattern.matcher(request.getImageContent());
            String fileExt = "jpg";
            if (matcher.find()) {
                fileExt = matcher.group(1);
            }
            final String fileName = new StringBuilder("cp_").append(request.getParentImageId())
                .append("_").append(System.currentTimeMillis())
                .append(".").append(fileExt)
                .toString();
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            final String imageContent = request.getImageContent().split(",")[1];
            final byte[] imgBytes = Base64.getDecoder().decode(imageContent);
            Thumbnails.of(new ByteArrayInputStream(imgBytes)).scale(1).outputQuality(0.5).toOutputStream(baos);
            System.out.println(imgBytes.length + " " + baos.toByteArray().length);
            final Long fileId = fileService.uploadFile(user.getTenantId(), user.getId(), fileName, new ByteArrayInputStream(baos.toByteArray()));
            final String fileUrl = fileService.getFileUrl(user.getTenantId(), user.getId(), fileId);
            final ImageCopy entity = new ImageCopy();
            entity.setParentImageId(request.getParentImageId());
            entity.setCopyName(request.getCopyName());
            entity.setFileUrl(fileUrl);
            entity.setFileType("." + fileExt);
            final Long id = imageCopyService.saveImageCopy(entity);
            return CommonResponse.ok("成功", id);
        } catch (IOException e) {
            logger.error("副本保存失败", e);
            return CommonResponse.failed("副本保存失败：" + e.getMessage());
        }
    }

}