package com.xforceplus.elephant.image.controller.logmq.process;

import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.LogMqDTO;
import com.xforceplus.elephant.image.core.repository.dao.LogMqDao;
import com.xforceplus.elephant.image.core.repository.model.LogMqEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetLogMqDetailProcess extends AbstractKeyProcess<Long, BaseRequest, LogMqDTO> {

    @Autowired
    private LogMqDao logMqDao;

    @Override
    protected CommonResponse<LogMqDTO> process(Long mqId, BaseRequest request) throws RuntimeException {
        final LogMqEntity entity = logMqDao.selectByPrimaryKey(mqId);
        final LogMqDTO dto = new LogMqDTO();
        BeanUtils.copyProperties(entity, dto);
        return CommonResponse.ok("成功", dto);
    }

}