package com.xforceplus.elephant.image.controller.specialinvoice;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.SpecialInvoiceApi;
import com.xforceplus.elephant.image.client.model.SaveSpecialInvoiceRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.specialinvoice.process.GetSpecialInvoiceConfigProcess;
import com.xforceplus.elephant.image.controller.specialinvoice.process.SaveSpecialInvoiceProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 特殊发票标记
 * @author rongying
 * @date 2023/6/26 11:45
 */
@ApiV1Image
public class SpecialInvoiceController extends BaseController implements SpecialInvoiceApi {

    @Autowired
    private GetSpecialInvoiceConfigProcess getSpecialInvoiceConfigProcess;
    @Autowired
    private SaveSpecialInvoiceProcess saveSpecialInvoiceProcess;

    @Override
    public CommonResponse getConfig() {
        final BaseRequest request = new BaseRequest();
        request.setRid(String.valueOf(System.currentTimeMillis()));
        return getSpecialInvoiceConfigProcess.execute(request);
    }

    @Override
    public CommonResponse saveSpecialInvoice(@RequestBody SaveSpecialInvoiceRequest request) {
        return saveSpecialInvoiceProcess.execute(request);
    }
}
