package com.xforceplus.elephant.image.controller.billdata.process.countinfo;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.baseconst.SettingsConstants;
import com.xforceplus.elephant.basecommon.enums.EntityConstant;
import com.xforceplus.elephant.basecommon.help.DateHelp;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BillSummaryCount;
import com.xforceplus.elephant.image.client.model.GetCountInfoRequest;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Dispatch(tenantCode = "CQP")
public class CQPGetBillCountInfoProcess extends DefaultGetBillCountInfoProcess {

    @Autowired
    private BaseBillService baseBillService;
    @Autowired
    private ImageService imageService;
    @Autowired
    private ConfigSettingsService configSettingsService;

    @Override
    protected CommonResponse<BillSummaryCount> process(GetCountInfoRequest request) throws RuntimeException {
        // 获取登录用户上下文
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }

        if (EntityConstant.BASE_BILL.equals(request.getEntityCode())) {
            request.setEntityCode("");
        }
        final Integer pendingSubmitCount = baseBillService
            .countBillByTenantIdAndScanUserId(authorizedUser.getTenantId(), Collections.singletonList(authorizedUser.getId()), request.getEntityCode(), Integer.valueOf(3));
        final Integer exceptionCount = baseBillService
            .countExceptionBillByTenantIdAndScanUserId(authorizedUser.getTenantId(), Collections.singletonList(authorizedUser.getId()), request.getEntityCode(), Integer.valueOf(3));
        final Integer warningCount = baseBillService
            .countWarningBillByTenantIdAndScanUserId(authorizedUser.getTenantId(), Collections.singletonList(authorizedUser.getId()), request.getEntityCode(), Integer.valueOf(3));

        final int day = configSettingsService.select(authorizedUser.getTenantId(), SettingsConstants.SEARCH_NO_REAL_DAY, Integer.class, 0);
        final List<Image> imageList = imageService.countImagesNoRelLastDayByCreateUserId(authorizedUser.getTenantId(), authorizedUser.getId(), day);

        //  查询待提交的租户个人下的单据
        final BillSummaryCount summaryCount = new BillSummaryCount();
        summaryCount.setPendingSubmitCount(pendingSubmitCount);
        summaryCount.setExceptionCount(exceptionCount);
        summaryCount.setWarningCount(warningCount);
        summaryCount.setImageCount(baseBillService.selectTicketImageCount(authorizedUser.getTenantId(),
            Collections.singletonList(authorizedUser.getId()), request.getEntityCode(), Integer.valueOf(3)));
        summaryCount.setNoRelImageCount(imageList.size());
        summaryCount.setBatchNo(imageList.stream().map(Image::getBatchNo).distinct().collect(Collectors.toList()));
        summaryCount.setStartTime(DateHelp.getDataZero(day));
        summaryCount.setEndTime(DateHelp.getEndTime());
        return CommonResponse.ok("", summaryCount);
    }

}
