package com.xforceplus.elephant.image.controller.businesslog;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.BusinessLogApi;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.core.facade.application.calculate.businesslog.BusinessLogFacade;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BusinessLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class BusinessLogController extends BaseController implements BusinessLogApi {

    @Autowired
    private BusinessLogFacade businessLogFacade;

    @Override
    public CommonResponse getBusinessLog(@RequestParam("businessId") Long businessId) {
        final List<BusinessLog> businessLogList = businessLogFacade.selectById(businessId);
        final List<Map> businessMapList = new ArrayList<>();
        if (businessLogList != null && businessLogList.size() > 0) {
            for (int i = 0; i < businessLogList.size(); i++) {
                final Map businessLogMap = businessLogList.get(i).toOQSMap();
                businessMapList.add(businessLogMap);
            }
        }
        return CommonResponse.ok("成功", businessMapList);
    }

}
