package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.GetBaseBillDetailRequest;
import com.xforceplus.elephant.image.core.business.application.compare.bill.domain.CompareBillAuditDetailVO;
import com.xforceplus.elephant.image.core.facade.application.compare.bill.CompareBillFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author liming
 * @date 2021/5/12 19:59
 */
@Service
public class GetCompareBillAuditDetailProcess extends AbstractProcess<GetBaseBillDetailRequest, CompareBillAuditDetailVO> {

    @Autowired
    private CompareBillFacade compareBillFacade;

    @Override
    protected void check(GetBaseBillDetailRequest request) throws ValidationException {
        checkEmpty(request.getBillCode(), "稽核单据号不能为空");
    }

    @Override
    protected CommonResponse<CompareBillAuditDetailVO> process(GetBaseBillDetailRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final CompareBillAuditDetailVO compareBillAuditDetailVO = compareBillFacade.getCompareBillAuditDetail(authorizedUser.getTenantId(), request.getBillCode());
        return CommonResponse.ok("成功", compareBillAuditDetailVO);
    }

}
