package com.xforceplus.elephant.image.controller.compare.image.process;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.model.GetImageReturnListRequest;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareGetImageReturnListProcess extends AbstractProcess<GetImageReturnListRequest, List<ImageDTO>> {

    @Autowired
    private CompareImageService imageService;
    @Autowired
    private CompareBaseBillService baseBillService;

    @Override
    protected void check(GetImageReturnListRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCode(), "单据ID不能为空");
    }

    @Override
    protected CommonResponse<List<ImageDTO>> process(GetImageReturnListRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        //查询单据是否已退回
        final BaseBill billEntity = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(), request.getBillCode());
        if (null == billEntity) {
            return CommonResponse.failed("没有找到业务单数据.");
        }
        if (!BillDataStatus._4.getCode().equals(billEntity.getBillDataStatus())) {
            return CommonResponse.ok("成功", Lists.newArrayList());
        }
        final List<ImageDTO> result = imageService.selectReturnImagesByBillCode(authorizedUser.getTenantId(), request.getBillCode(), request.getReturnReason()).stream()
            .map(entity -> {
                final ImageDTO dto = new JSONObject(entity.toOQSMap()).toJavaObject(ImageDTO.class);
                dto.setFileUrl(ApiV1Image.PATH + "/image/" + entity.getId() + entity.getFileTypeHandle() + "?rid=" + System.currentTimeMillis());
                dto.setFileUrlHandle(null);
                dto.setFileUrlOrigin(null);
                return dto;
            }).collect(Collectors.toList());
        return CommonResponse.ok("成功", result);
    }

}